/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_13.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v4_13.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_13.monitoring.v1.Rule;
import io.fabric8.openshift.api.model.v4_13.monitoring.v1.RuleFluent;
import io.fabric8.openshift.api.model.v4_13.monitoring.v1.RuleFluentImpl;
import java.util.Objects;

public class RuleBuilder
extends RuleFluentImpl<RuleBuilder>
implements VisitableBuilder<Rule, RuleBuilder> {
    RuleFluent<?> fluent;
    Boolean validationEnabled;

    public RuleBuilder() {
        this(true);
    }

    public RuleBuilder(Boolean validationEnabled) {
        this(new Rule(), validationEnabled);
    }

    public RuleBuilder(RuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RuleBuilder(RuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Rule(), validationEnabled);
    }

    public RuleBuilder(RuleFluent<?> fluent, Rule instance) {
        this(fluent, instance, true);
    }

    public RuleBuilder(RuleFluent<?> fluent, Rule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAlert(instance.getAlert());
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withExpr(instance.getExpr());
        fluent.withFor(instance.getFor());
        fluent.withLabels(instance.getLabels());
        fluent.withRecord(instance.getRecord());
        this.validationEnabled = validationEnabled;
    }

    public RuleBuilder(Rule instance) {
        this(instance, (Boolean)true);
    }

    public RuleBuilder(Rule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAlert(instance.getAlert());
        this.withAnnotations(instance.getAnnotations());
        this.withExpr(instance.getExpr());
        this.withFor(instance.getFor());
        this.withLabels(instance.getLabels());
        this.withRecord(instance.getRecord());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Rule build() {
        Rule buildable = new Rule(this.fluent.getAlert(), this.fluent.getAnnotations(), this.fluent.getExpr(), this.fluent.getFor(), this.fluent.getLabels(), this.fluent.getRecord());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleBuilder that = (RuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

