/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_13.utils;

import io.fabric8.kubernetes.api.model.v4_13.AuthInfo;
import io.fabric8.kubernetes.clnt.v4_13.Config;
import io.fabric8.kubernetes.clnt.v4_13.internal.KubeConfigUtils;
import io.fabric8.kubernetes.clnt.v4_13.utils.OpenIDConnectionUtils;
import java.io.File;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class OIDCTokenRefreshInterceptor
implements Interceptor {
    private Config config;

    public OIDCTokenRefreshInterceptor(Config config) {
        this.config = config;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        io.fabric8.kubernetes.api.model.v4_13.Config kubeConfig;
        AuthInfo currentAuthInfo;
        Request request = chain.request();
        Response response = chain.proceed(request);
        if (response.code() == 401 && (currentAuthInfo = KubeConfigUtils.getUserAuthInfo(kubeConfig = KubeConfigUtils.parseConfig(new File(Config.getKubeconfigFilename())), this.config.getCurrentContext().getContext())).getAuthProvider() != null) {
            String newAccessToken = OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig(currentAuthInfo.getAuthProvider().getConfig());
            Request authReqWithUpdatedToken = chain.request().newBuilder().header("Authorization", "Bearer " + newAccessToken).build();
            this.config.setOauthToken(newAccessToken);
            return chain.proceed(authReqWithUpdatedToken);
        }
        return response;
    }
}

