/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_13.osgi;

import io.fabric8.kubernetes.api.model.v4_13.APIService;
import io.fabric8.kubernetes.api.model.v4_13.APIServiceList;
import io.fabric8.kubernetes.api.model.v4_13.Binding;
import io.fabric8.kubernetes.api.model.v4_13.ComponentStatus;
import io.fabric8.kubernetes.api.model.v4_13.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v4_13.ConfigMap;
import io.fabric8.kubernetes.api.model.v4_13.ConfigMapList;
import io.fabric8.kubernetes.api.model.v4_13.Doneable;
import io.fabric8.kubernetes.api.model.v4_13.DoneableAPIService;
import io.fabric8.kubernetes.api.model.v4_13.DoneableBinding;
import io.fabric8.kubernetes.api.model.v4_13.DoneableComponentStatus;
import io.fabric8.kubernetes.api.model.v4_13.DoneableConfigMap;
import io.fabric8.kubernetes.api.model.v4_13.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.v4_13.DoneableEvent;
import io.fabric8.kubernetes.api.model.v4_13.DoneableLimitRange;
import io.fabric8.kubernetes.api.model.v4_13.DoneableNamespace;
import io.fabric8.kubernetes.api.model.v4_13.DoneableNode;
import io.fabric8.kubernetes.api.model.v4_13.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.v4_13.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v4_13.DoneablePod;
import io.fabric8.kubernetes.api.model.v4_13.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.v4_13.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.v4_13.DoneableSecret;
import io.fabric8.kubernetes.api.model.v4_13.DoneableService;
import io.fabric8.kubernetes.api.model.v4_13.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.v4_13.Endpoints;
import io.fabric8.kubernetes.api.model.v4_13.EndpointsList;
import io.fabric8.kubernetes.api.model.v4_13.Event;
import io.fabric8.kubernetes.api.model.v4_13.EventList;
import io.fabric8.kubernetes.api.model.v4_13.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_13.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v4_13.LimitRange;
import io.fabric8.kubernetes.api.model.v4_13.LimitRangeList;
import io.fabric8.kubernetes.api.model.v4_13.Namespace;
import io.fabric8.kubernetes.api.model.v4_13.NamespaceList;
import io.fabric8.kubernetes.api.model.v4_13.Node;
import io.fabric8.kubernetes.api.model.v4_13.NodeList;
import io.fabric8.kubernetes.api.model.v4_13.PersistentVolume;
import io.fabric8.kubernetes.api.model.v4_13.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v4_13.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v4_13.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v4_13.Pod;
import io.fabric8.kubernetes.api.model.v4_13.PodList;
import io.fabric8.kubernetes.api.model.v4_13.ReplicationController;
import io.fabric8.kubernetes.api.model.v4_13.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v4_13.ResourceQuota;
import io.fabric8.kubernetes.api.model.v4_13.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v4_13.RootPaths;
import io.fabric8.kubernetes.api.model.v4_13.Secret;
import io.fabric8.kubernetes.api.model.v4_13.SecretList;
import io.fabric8.kubernetes.api.model.v4_13.ServiceAccount;
import io.fabric8.kubernetes.api.model.v4_13.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v4_13.ServiceList;
import io.fabric8.kubernetes.api.model.v4_13.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.v4_13.apiextensions.v1beta1.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.v4_13.apiextensions.v1beta1.DoneableCustomResourceDefinition;
import io.fabric8.kubernetes.api.model.v4_13.authentication.DoneableTokenReview;
import io.fabric8.kubernetes.api.model.v4_13.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.v4_13.certificates.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.v4_13.certificates.CertificateSigningRequestList;
import io.fabric8.kubernetes.api.model.v4_13.certificates.DoneableCertificateSigningRequest;
import io.fabric8.kubernetes.api.model.v4_13.coordination.v1.DoneableLease;
import io.fabric8.kubernetes.api.model.v4_13.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.v4_13.coordination.v1.LeaseList;
import io.fabric8.kubernetes.api.model.v4_13.node.v1beta1.DoneableRuntimeClass;
import io.fabric8.kubernetes.api.model.v4_13.node.v1beta1.RuntimeClass;
import io.fabric8.kubernetes.api.model.v4_13.node.v1beta1.RuntimeClassList;
import io.fabric8.kubernetes.clnt.v4_13.Adapters;
import io.fabric8.kubernetes.clnt.v4_13.AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.BaseClient;
import io.fabric8.kubernetes.clnt.v4_13.Config;
import io.fabric8.kubernetes.clnt.v4_13.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v4_13.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_13.ExtensionAdapter;
import io.fabric8.kubernetes.clnt.v4_13.Handlers;
import io.fabric8.kubernetes.clnt.v4_13.KubernetesClient;
import io.fabric8.kubernetes.clnt.v4_13.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_13.OAuthTokenProvider;
import io.fabric8.kubernetes.clnt.v4_13.RequestConfig;
import io.fabric8.kubernetes.clnt.v4_13.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_13.VersionInfo;
import io.fabric8.kubernetes.clnt.v4_13.dsl.ApiextensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.AuthorizationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.BatchAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Createable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v4_13.dsl.MetricAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v4_13.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_13.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v4_13.dsl.PolicyAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.RbacAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_13.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_13.dsl.SchedulingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v4_13.dsl.SettingsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.StorageAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.V1APIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_13.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v4_13.dsl.internal.RawCustomResourceOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_13.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.clnt.v4_13.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.clnt.v4_13.extended.run.RunOperations;
import io.fabric8.kubernetes.clnt.v4_13.informers.SharedInformerFactory;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true, configurationPid="io.fabric8.kubernetes.clnt.v4_13", policy=ConfigurationPolicy.OPTIONAL)
@Service(value={KubernetesClient.class, NamespacedKubernetesClient.class})
@References(value={@Reference(referenceInterface=ResourceHandler.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindResourceHandler", unbind="unbindResourceHandler"), @Reference(referenceInterface=ExtensionAdapter.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindExtensionAdapter", unbind="unbindExtensionAdapter"), @Reference(referenceInterface=OAuthTokenProvider.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY, bind="bindOAuthTokenProvider", unbind="unbindOAuthTokenProvider")})
public class ManagedKubernetesClient
extends BaseClient
implements NamespacedKubernetesClient {
    private NamespacedKubernetesClient delegate;
    private OAuthTokenProvider provider;

    @Activate
    public void activate(Map<String, Object> properties) {
        ConfigBuilder builder = new ConfigBuilder();
        if (properties.containsKey("kubernetes.master")) {
            builder.withMasterUrl((String)properties.get("kubernetes.master"));
        }
        if (properties.containsKey("kubernetes.api.version")) {
            builder.withApiVersion((String)properties.get("kubernetes.api.version"));
        }
        if (properties.containsKey("kubernetes.namespace")) {
            builder.withNamespace((String)properties.get("kubernetes.namespace"));
        }
        if (properties.containsKey("kubernetes.certs.ca.file")) {
            builder.withCaCertFile((String)properties.get("kubernetes.certs.ca.file"));
        }
        if (properties.containsKey("kubernetes.certs.ca.data")) {
            builder.withCaCertData((String)properties.get("kubernetes.certs.ca.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.file")) {
            builder.withClientCertFile((String)properties.get("kubernetes.certs.client.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.data")) {
            builder.withClientCertData((String)properties.get("kubernetes.certs.client.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.file")) {
            builder.withClientKeyFile((String)properties.get("kubernetes.certs.client.key.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.data")) {
            builder.withClientKeyData((String)properties.get("kubernetes.certs.client.key.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.algo")) {
            builder.withClientKeyAlgo((String)properties.get("kubernetes.certs.client.key.algo"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.passphrase")) {
            builder.withClientKeyPassphrase((String)properties.get("kubernetes.certs.client.key.passphrase"));
        }
        if (properties.containsKey("kubernetes.auth.basic.username")) {
            builder.withUsername((String)properties.get("kubernetes.auth.basic.username"));
        }
        if (properties.containsKey("kubernetes.auth.basic.password")) {
            builder.withPassword((String)properties.get("kubernetes.auth.basic.password"));
        }
        if (properties.containsKey("kubernetes.auth.token")) {
            builder.withOauthToken((String)properties.get("kubernetes.auth.token"));
        }
        if (properties.containsKey("kubernetes.watch.reconnectInterval")) {
            builder.withWatchReconnectInterval(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectInterval")));
        }
        if (properties.containsKey("kubernetes.watch.reconnectLimit")) {
            builder.withWatchReconnectLimit(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectLimit")));
        }
        if (properties.containsKey("kubernetes.request.timeout")) {
            builder.withRequestTimeout(Integer.parseInt((String)properties.get("kubernetes.request.timeout")));
        }
        if (properties.containsKey("http.proxy")) {
            builder.withHttpProxy((String)properties.get("http.proxy"));
        }
        if (properties.containsKey("https.proxy")) {
            builder.withHttpsProxy((String)properties.get("https.proxy"));
        }
        if (properties.containsKey("no.proxy")) {
            String noProxyProperty = (String)properties.get("no.proxy");
            builder.withNoProxy(noProxyProperty.split(","));
        }
        if (properties.containsKey("kubernetes.websocket.timeout")) {
            builder.withWebsocketTimeout(Long.parseLong((String)properties.get("kubernetes.websocket.timeout")));
        }
        if (properties.containsKey("kubernetes.websocket.ping.interval")) {
            builder.withWebsocketPingInterval(Long.parseLong((String)properties.get("kubernetes.websocket.ping.interval")));
        }
        if (properties.containsKey("kubernetes.truststore.file")) {
            builder.withTrustStoreFile((String)properties.get("kubernetes.truststore.file"));
        }
        if (properties.containsKey("kubernetes.truststore.passphrase")) {
            builder.withTrustStorePassphrase((String)properties.get("kubernetes.truststore.passphrase"));
        }
        if (properties.containsKey("kubernetes.keystore.file")) {
            builder.withKeyStoreFile((String)properties.get("kubernetes.keystore.file"));
        }
        if (properties.containsKey("kubernetes.keystore.passphrase")) {
            builder.withKeyStorePassphrase((String)properties.get("kubernetes.keystore.passphrase"));
        }
        if (this.provider != null) {
            builder.withOauthTokenProvider(this.provider);
        }
        this.delegate = new DefaultKubernetesClient(builder.build());
    }

    @Deactivate
    public void deactivate() {
        this.delegate.close();
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(HasMetadata ... items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata is) {
        return this.delegate.resource(is);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Binding, KubernetesResourceList<Binding>, DoneableBinding, Resource<Binding, DoneableBinding>> bindings() {
        return this.delegate.bindings();
    }

    @Override
    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<io.fabric8.kubernetes.api.model.v4_13.Service, ServiceList, DoneableService, ServiceResource<io.fabric8.kubernetes.api.model.v4_13.Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public MixedOperation<APIService, APIServiceList, DoneableAPIService, Resource<APIService, DoneableAPIService>> apiServices() {
        return this.delegate.apiServices();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    @Override
    public VersionInfo getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public V1APIGroupDSL v1() {
        return this.delegate.v1();
    }

    @Override
    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.delegate.admissionRegistration();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.delegate.apps();
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.delegate.autoscaling();
    }

    @Override
    public SchedulingAPIGroupDSL scheduling() {
        return this.delegate.scheduling();
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.delegate.network();
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.delegate.storage();
    }

    @Override
    public SettingsAPIGroupDSL settings() {
        return this.delegate.settings();
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.delegate.batch();
    }

    @Override
    public MetricAPIGroupDSL top() {
        return this.delegate.top();
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.delegate.policy();
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.delegate.rbac();
    }

    @Override
    public NonNamespaceOperation<CustomResourceDefinition, CustomResourceDefinitionList, DoneableCustomResourceDefinition, Resource<CustomResourceDefinition, DoneableCustomResourceDefinition>> customResourceDefinitions() {
        return this.delegate.customResourceDefinitions();
    }

    @Override
    public ApiextensionsAPIGroupDSL apiextensions() {
        return this.delegate.apiextensions();
    }

    @Override
    public NonNamespaceOperation<CertificateSigningRequest, CertificateSigningRequestList, DoneableCertificateSigningRequest, Resource<CertificateSigningRequest, DoneableCertificateSigningRequest>> certificateSigningRequests() {
        return this.delegate.certificateSigningRequests();
    }

    @Override
    public AuthorizationAPIGroupDSL authorization() {
        return this.delegate.authorization();
    }

    @Override
    public Createable<TokenReview, TokenReview, DoneableTokenReview> tokenReviews() {
        return this.delegate.tokenReviews();
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResources(CustomResourceDefinitionContext crdContext, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return this.delegate.customResources(crdContext, resourceType, listClass, doneClass);
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResources(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return this.delegate.customResources(crd, resourceType, listClass, doneClass);
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResource(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return this.customResources(crd, resourceType, listClass, doneClass);
    }

    @Override
    public RawCustomResourceOperationsImpl customResource(CustomResourceDefinitionContext customResourceDefinition) {
        return this.delegate.customResource(customResourceDefinition);
    }

    @Override
    public SharedInformerFactory informers() {
        return this.delegate.informers();
    }

    @Override
    public SharedInformerFactory informers(ExecutorService executorService) {
        return this.delegate.informers(executorService);
    }

    public LeaderElectorBuilder<NamespacedKubernetesClient> leaderElector() {
        return this.delegate.leaderElector();
    }

    @Override
    public MixedOperation<Lease, LeaseList, DoneableLease, Resource<Lease, DoneableLease>> leases() {
        return this.delegate.leases();
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public <C> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public void bindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.register(resourceHandler);
    }

    public void unbindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.unregister(resourceHandler);
    }

    public void bindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.register(adapter);
    }

    public void unbindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.unregister(adapter);
    }

    public void bindOAuthTokenProvider(OAuthTokenProvider provider) {
        this.provider = provider;
    }

    public void unbindOAuthTokenProvider(OAuthTokenProvider provider) {
        if (this.provider == provider) {
            this.provider = null;
        }
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return (NamespacedKubernetesClient)this.delegate.inAnyNamespace();
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String name) {
        return (NamespacedKubernetesClient)this.delegate.inNamespace(name);
    }

    @Override
    public FunctionCallable<NamespacedKubernetesClient> withRequestConfig(RequestConfig requestConfig) {
        return this.delegate.withRequestConfig(requestConfig);
    }

    @Override
    public RunOperations run() {
        return new RunOperations(this.httpClient, this.getConfiguration(), this.getNamespace(), new RunConfigBuilder());
    }

    @Override
    public NonNamespaceOperation<RuntimeClass, RuntimeClassList, DoneableRuntimeClass, Resource<RuntimeClass, DoneableRuntimeClass>> runtimeClasses() {
        return this.delegate.runtimeClasses();
    }
}

