/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_13.handlers.networking.v1;

import io.fabric8.kubernetes.api.model.v4_13.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_13.ListOptions;
import io.fabric8.kubernetes.api.model.v4_13.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.v4_13.networking.v1.NetworkPolicyBuilder;
import io.fabric8.kubernetes.clnt.v4_13.Config;
import io.fabric8.kubernetes.clnt.v4_13.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_13.Watch;
import io.fabric8.kubernetes.clnt.v4_13.Watcher;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_13.dsl.internal.networking.v1.NetworkPolicyOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class NetworkPolicyHandler
implements ResourceHandler<NetworkPolicy, NetworkPolicyBuilder> {
    @Override
    public String getKind() {
        return NetworkPolicy.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "networking.k8s.io/v1";
    }

    @Override
    public NetworkPolicy create(OkHttpClient client, Config config, String namespace, NetworkPolicy item) {
        return (NetworkPolicy)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new NetworkPolicy[0]);
    }

    @Override
    public NetworkPolicy replace(OkHttpClient client, Config config, String namespace, NetworkPolicy item) {
        return (NetworkPolicy)((Resource)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public NetworkPolicy reload(OkHttpClient client, Config config, String namespace, NetworkPolicy item) {
        return (NetworkPolicy)((Gettable)((Resource)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public NetworkPolicyBuilder edit(NetworkPolicy item) {
        return new NetworkPolicyBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, NetworkPolicy item) {
        return (Boolean)new NetworkPolicyOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, NetworkPolicy item, Watcher<NetworkPolicy> watcher) {
        return (Watch)((Resource)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, NetworkPolicy item, String resourceVersion, Watcher<NetworkPolicy> watcher) {
        return (Watch)((Resource)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, NetworkPolicy item, ListOptions options, Watcher<NetworkPolicy> watcher) {
        return (Watch)((Resource)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public NetworkPolicy waitUntilReady(OkHttpClient client, Config config, String namespace, NetworkPolicy item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (NetworkPolicy)((Resource)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public NetworkPolicy waitUntilCondition(OkHttpClient client, Config config, String namespace, NetworkPolicy item, Predicate<NetworkPolicy> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (NetworkPolicy)((Resource)new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

