/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_13.extended.leaderelection.resourcelock;

import io.fabric8.kubernetes.api.model.v4_13.coordination.v1.DoneableLease;
import io.fabric8.kubernetes.api.model.v4_13.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.v4_13.coordination.v1.LeaseFluent;
import io.fabric8.kubernetes.clnt.v4_13.KubernetesClient;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Namespaceable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Replaceable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_13.extended.leaderelection.resourcelock.LeaderElectionRecord;
import io.fabric8.kubernetes.clnt.v4_13.extended.leaderelection.resourcelock.Lock;
import io.fabric8.kubernetes.clnt.v4_13.extended.leaderelection.resourcelock.LockException;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;

public class LeaseLock
implements Lock {
    private final String leaseNamespace;
    private final String leaseName;
    private final String identity;

    public LeaseLock(String leaseNamespace, String leaseName, String identity) {
        this.leaseNamespace = Objects.requireNonNull(leaseNamespace, "leaseNamespace is required");
        this.leaseName = Objects.requireNonNull(leaseName, "leaseName is required");
        this.identity = Objects.requireNonNull(identity, "identity is required");
    }

    @Override
    public <C extends Namespaceable<C> & KubernetesClient> LeaderElectionRecord get(C client) {
        Lease lease = (Lease)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.leaseNamespace)))).leases().withName(this.leaseName)).get();
        return Optional.ofNullable(lease).map(Lease::getSpec).map(spec -> {
            LeaderElectionRecord ret = new LeaderElectionRecord(spec.getHolderIdentity(), Duration.ofSeconds(spec.getLeaseDurationSeconds().intValue()), spec.getAcquireTime(), spec.getRenewTime(), Optional.ofNullable(spec.getLeaseTransitions()).orElse(0));
            ret.setVersion((Serializable)((Object)lease.getMetadata().getResourceVersion()));
            return ret;
        }).orElse(null);
    }

    @Override
    public <C extends Namespaceable<C> & KubernetesClient> void create(C client, LeaderElectionRecord leaderElectionRecord) throws LockException {
        try {
            ((DoneableLease)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((DoneableLease)((LeaseFluent.MetadataNested)((LeaseFluent.MetadataNested)((DoneableLease)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.leaseNamespace)))).leases().withName(this.leaseName)).createNew()).withNewMetadata().withNamespace(this.leaseNamespace)).withName(this.leaseName)).endMetadata()).withNewSpec().withHolderIdentity(leaderElectionRecord.getHolderIdentity())).withLeaseDurationSeconds((int)leaderElectionRecord.getLeaseDuration().get(ChronoUnit.SECONDS))).withAcquireTime(leaderElectionRecord.getAcquireTime())).withRenewTime(leaderElectionRecord.getRenewTime())).withLeaseTransitions(leaderElectionRecord.getLeaderTransitions())).endSpec()).done();
        }
        catch (Exception e) {
            throw new LockException("Unable to create LeaseLock", e);
        }
    }

    @Override
    public <C extends Namespaceable<C> & KubernetesClient> void update(C client, LeaderElectionRecord leaderElectionRecord) throws LockException {
        try {
            Lease toReplace = (Lease)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.leaseNamespace)))).leases().withName(this.leaseName)).get();
            toReplace.getSpec().setHolderIdentity(leaderElectionRecord.getHolderIdentity());
            toReplace.getSpec().setLeaseDurationSeconds((int)leaderElectionRecord.getLeaseDuration().get(ChronoUnit.SECONDS));
            toReplace.getSpec().setAcquireTime(leaderElectionRecord.getAcquireTime());
            toReplace.getSpec().setRenewTime(leaderElectionRecord.getRenewTime());
            toReplace.getSpec().setLeaseTransitions(leaderElectionRecord.getLeaderTransitions());
            ((Replaceable)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.leaseNamespace)))).leases().withName(this.leaseName)).lockResourceVersion((String)((Object)Objects.requireNonNull(leaderElectionRecord.getVersion())))).replace(toReplace);
        }
        catch (Exception e) {
            throw new LockException("Unable to update LeaseLock", e);
        }
    }

    @Override
    public String identity() {
        return this.identity;
    }

    @Override
    public String describe() {
        return String.format("LeaseLock: %s - %s (%s)", this.leaseNamespace, this.leaseName, this.identity);
    }
}

