/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_13.dsl.internal;

import io.fabric8.kubernetes.api.builder.v4_13.TypedVisitor;
import io.fabric8.kubernetes.api.builder.v4_13.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.v4_13.Visitor;
import io.fabric8.kubernetes.api.model.v4_13.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_13.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_13.KubernetesList;
import io.fabric8.kubernetes.api.model.v4_13.ListOptions;
import io.fabric8.kubernetes.api.model.v4_13.ObjectMetaBuilder;
import io.fabric8.kubernetes.clnt.v4_13.Config;
import io.fabric8.kubernetes.clnt.v4_13.Handlers;
import io.fabric8.kubernetes.clnt.v4_13.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_13.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_13.Watch;
import io.fabric8.kubernetes.clnt.v4_13.Watcher;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Applicable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.CascadingDeletable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Readiable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Waitable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v4_13.handlers.KubernetesListHandler;
import io.fabric8.kubernetes.clnt.v4_13.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v4_13.utils.CreateOrReplaceHelper;
import io.fabric8.kubernetes.clnt.v4_13.utils.DeleteAndCreateHelper;
import io.fabric8.kubernetes.clnt.v4_13.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl
extends OperationSupport
implements NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean>,
Waitable<HasMetadata, HasMetadata>,
Readiable {
    private final String fallbackNamespace;
    private final String explicitNamespace;
    private final Boolean fromServer;
    private final Boolean deletingExisting;
    private final List<Visitor> visitors;
    private final Object item;
    private final ResourceHandler handler;
    private final long gracePeriodSeconds;
    private final DeletionPropagation propagationPolicy;
    private final Boolean cascading;
    private final long watchRetryInitialBackoffMillis;
    private final double watchRetryBackoffMultiplier;

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, InputStream is, Boolean cascading, long watchRetryInitialBackoffMillis, double watchRetryBackoffMultiplier) {
        this(client, config, namespace, explicitNamespace, fromServer, deletingExisting, visitors, NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.unmarshal(is), -1L, null, cascading, watchRetryInitialBackoffMillis, watchRetryBackoffMultiplier);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, Object item, long gracePeriodSeconds, DeletionPropagation propagationPolicy, Boolean cascading, long watchRetryInitialBackoffMillis, double watchRetryBackoffMultiplier) {
        super(client, config);
        this.fallbackNamespace = namespace;
        this.explicitNamespace = explicitNamespace;
        this.fromServer = fromServer;
        this.deletingExisting = deletingExisting;
        this.visitors = visitors != null ? new ArrayList<Visitor>(visitors) : new ArrayList();
        this.item = item;
        this.handler = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item);
        this.cascading = cascading;
        this.watchRetryInitialBackoffMillis = watchRetryInitialBackoffMillis;
        this.watchRetryBackoffMultiplier = watchRetryBackoffMultiplier;
        if (this.handler == null) {
            throw new KubernetesClientException("No handler found for object:" + item);
        }
        this.gracePeriodSeconds = gracePeriodSeconds;
        this.propagationPolicy = propagationPolicy;
        this.visitors.add(new ChangeNamespace(explicitNamespace, this.fallbackNamespace));
    }

    @Override
    public HasMetadata apply() {
        return this.createOrReplace();
    }

    @Override
    public HasMetadata createOrReplace() {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        String namespaceToUse = meta.getMetadata().getNamespace();
        if (Boolean.TRUE.equals(this.deletingExisting)) {
            return DeleteAndCreateHelper.deleteAndCreateItem(this.client, this.config, meta, h, namespaceToUse, this.propagationPolicy);
        }
        return CreateOrReplaceHelper.createOrReplaceItem(this.client, this.config, meta, h, namespaceToUse);
    }

    @Override
    public Waitable<HasMetadata, HasMetadata> createOrReplaceAnd() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.createOrReplace(), this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public Boolean delete() {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.delete(this.client, this.config, meta.getMetadata().getNamespace(), this.propagationPolicy, meta);
    }

    @Override
    public HasMetadata get() {
        if (this.fromServer.booleanValue()) {
            HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
            ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
            HasMetadata reloaded = h.reload(this.client, this.config, meta.getMetadata().getNamespace(), meta);
            if (reloaded != null) {
                HasMetadata edited = reloaded;
                for (Visitor v : this.visitors) {
                    edited = (HasMetadata)((VisitableBuilder)h.edit(edited).accept(v)).build();
                }
                return edited;
            }
            return null;
        }
        return NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
    }

    @Override
    public VisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> inNamespace(String explicitNamespace) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public Gettable<HasMetadata> fromServer() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, true, this.deletingExisting, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public Applicable<HasMetadata> deletingExisting() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public VisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> accept(Visitor visitor) {
        ArrayList<Visitor> newVisitors = new ArrayList<Visitor>(this.visitors);
        newVisitors.add(visitor);
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, newVisitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public CascadingDeletable<Boolean> withGracePeriod(long gracePeriodSeconds) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public CascadingDeletable<Boolean> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public Deletable<Boolean> cascading(boolean cascading) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public Waitable<HasMetadata, HasMetadata> withWaitRetryBackoff(long initialBackoff, TimeUnit backoffUnit, double backoffMultiplier) {
        long watchRetryInitialBackoffMillis = backoffUnit.toMillis(initialBackoff);
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, watchRetryInitialBackoffMillis, backoffMultiplier);
    }

    @Override
    public Watch watch(Watcher<HasMetadata> watcher) {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.watch(this.client, this.config, meta.getMetadata().getNamespace(), meta, watcher);
    }

    @Override
    public Watch watch(String resourceVersion, Watcher<HasMetadata> watcher) {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.watch(this.client, this.config, meta.getMetadata().getNamespace(), meta, resourceVersion, watcher);
    }

    @Override
    public Watch watch(ListOptions options, Watcher<HasMetadata> watcher) {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.watch(this.client, this.config, meta.getMetadata().getNamespace(), meta, options, watcher);
    }

    @Override
    public Boolean isReady() {
        return Readiness.isReady(this.get());
    }

    @Override
    public HasMetadata waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.get()), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.waitUntilReady(this.client, this.config, meta.getMetadata().getNamespace(), meta, amount, timeUnit);
    }

    @Override
    public HasMetadata waitUntilCondition(Predicate<HasMetadata> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.get()), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.waitUntilCondition(this.client, this.config, meta.getMetadata().getNamespace(), meta, condition, amount, timeUnit);
    }

    private static HasMetadata acceptVisitors(HasMetadata item, List<Visitor> visitors) {
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item);
        Object builder = h.edit(item);
        for (Visitor v : visitors) {
            builder.accept(v);
        }
        return (HasMetadata)builder.build();
    }

    private static List<HasMetadata> acceptVisitors(List<HasMetadata> list, List<Visitor> visitors) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        for (HasMetadata item : list) {
            ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item);
            Object builder = h.edit(item);
            for (Visitor v : visitors) {
                builder.accept(v);
            }
            result.add((HasMetadata)builder.build());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> HasMetadata asHasMetadata(T item) {
        if (item instanceof HasMetadata) {
            return (HasMetadata)item;
        }
        if (!(item instanceof String)) throw new IllegalArgumentException("Item needs to be an instance of HasMetadata or String.");
        try (ByteArrayInputStream is = new ByteArrayInputStream(((String)item).getBytes(StandardCharsets.UTF_8));){
            HasMetadata hasMetadata = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.unmarshal(is));
            return hasMetadata;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private static <T> ResourceHandler handlerOf(T item) {
        if (item instanceof HasMetadata) {
            return Handlers.get(((HasMetadata)item).getKind(), ((HasMetadata)item).getApiVersion());
        }
        if (item instanceof KubernetesList) {
            return new KubernetesListHandler();
        }
        throw new IllegalArgumentException("Could not find a registered handler for item: [" + item + "].");
    }

    private class ChangeNamespace
    extends TypedVisitor<ObjectMetaBuilder> {
        private final String explicitNamespace;
        private final String fallbackNamespace;

        private ChangeNamespace(String explicitNamespace, String fallbackNamespace) {
            this.explicitNamespace = explicitNamespace;
            this.fallbackNamespace = fallbackNamespace;
        }

        @Override
        public void visit(ObjectMetaBuilder builder) {
            if (Utils.isNotNullOrEmpty(this.explicitNamespace)) {
                builder.withNamespace(this.explicitNamespace);
            } else if (Utils.isNullOrEmpty(builder.getNamespace())) {
                builder.withNamespace(this.fallbackNamespace);
            }
        }
    }
}

