/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_13.extensions;

import io.fabric8.kubernetes.api.builder.v4_13.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_13.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.v4_13.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.v4_13.extensions.HTTPIngressPathFluentImpl;
import java.util.Objects;

public class HTTPIngressPathBuilder
extends HTTPIngressPathFluentImpl<HTTPIngressPathBuilder>
implements VisitableBuilder<HTTPIngressPath, HTTPIngressPathBuilder> {
    HTTPIngressPathFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPIngressPathBuilder() {
        this(true);
    }

    public HTTPIngressPathBuilder(Boolean validationEnabled) {
        this(new HTTPIngressPath(), validationEnabled);
    }

    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HTTPIngressPath(), validationEnabled);
    }

    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent, HTTPIngressPath instance) {
        this(fluent, instance, true);
    }

    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent, HTTPIngressPath instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBackend(instance.getBackend());
        fluent.withPath(instance.getPath());
        fluent.withPathType(instance.getPathType());
        this.validationEnabled = validationEnabled;
    }

    public HTTPIngressPathBuilder(HTTPIngressPath instance) {
        this(instance, (Boolean)true);
    }

    public HTTPIngressPathBuilder(HTTPIngressPath instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBackend(instance.getBackend());
        this.withPath(instance.getPath());
        this.withPathType(instance.getPathType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public HTTPIngressPath build() {
        HTTPIngressPath buildable = new HTTPIngressPath(this.fluent.getBackend(), this.fluent.getPath(), this.fluent.getPathType());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPIngressPathBuilder that = (HTTPIngressPathBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

