/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_13;

import io.fabric8.kubernetes.api.builder.v4_13.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_13.SeccompProfile;
import io.fabric8.kubernetes.api.model.v4_13.SeccompProfileFluent;
import io.fabric8.kubernetes.api.model.v4_13.SeccompProfileFluentImpl;
import java.util.Objects;

public class SeccompProfileBuilder
extends SeccompProfileFluentImpl<SeccompProfileBuilder>
implements VisitableBuilder<SeccompProfile, SeccompProfileBuilder> {
    SeccompProfileFluent<?> fluent;
    Boolean validationEnabled;

    public SeccompProfileBuilder() {
        this(true);
    }

    public SeccompProfileBuilder(Boolean validationEnabled) {
        this(new SeccompProfile(), validationEnabled);
    }

    public SeccompProfileBuilder(SeccompProfileFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SeccompProfileBuilder(SeccompProfileFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SeccompProfile(), validationEnabled);
    }

    public SeccompProfileBuilder(SeccompProfileFluent<?> fluent, SeccompProfile instance) {
        this(fluent, instance, true);
    }

    public SeccompProfileBuilder(SeccompProfileFluent<?> fluent, SeccompProfile instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLocalhostProfile(instance.getLocalhostProfile());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public SeccompProfileBuilder(SeccompProfile instance) {
        this(instance, (Boolean)true);
    }

    public SeccompProfileBuilder(SeccompProfile instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLocalhostProfile(instance.getLocalhostProfile());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SeccompProfile build() {
        SeccompProfile buildable = new SeccompProfile(this.fluent.getLocalhostProfile(), this.fluent.getType());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SeccompProfileBuilder that = (SeccompProfileBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

