/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_13;

import io.fabric8.kubernetes.api.builder.v4_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_13.Predicate;
import io.fabric8.kubernetes.api.model.v4_13.RootPaths;
import io.fabric8.kubernetes.api.model.v4_13.RootPathsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class RootPathsFluentImpl<A extends RootPathsFluent<A>>
extends BaseFluent<A>
implements RootPathsFluent<A> {
    private List<String> paths = new ArrayList<String>();

    public RootPathsFluentImpl() {
    }

    public RootPathsFluentImpl(RootPaths instance) {
        this.withPaths(instance.getPaths());
    }

    @Override
    public A addToPaths(int index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPaths(int index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPaths(String ... items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPaths(Collection<String> items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPaths(String ... items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPaths(Collection<String> items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public String getPath(int index) {
        return this.paths.get(index);
    }

    @Override
    public String getFirstPath() {
        return this.paths.get(0);
    }

    @Override
    public String getLastPath() {
        return this.paths.get(this.paths.size() - 1);
    }

    @Override
    public String getMatchingPath(Predicate<String> predicate) {
        for (String item : this.paths) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPath(Predicate<String> predicate) {
        for (String item : this.paths) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPaths(List<String> paths) {
        if (this.paths != null) {
            this._visitables.get("paths").removeAll(this.paths);
        }
        if (paths != null) {
            this.paths = new ArrayList<String>();
            for (String item : paths) {
                this.addToPaths(item);
            }
        } else {
            this.paths = null;
        }
        return (A)this;
    }

    @Override
    public A withPaths(String ... paths) {
        if (this.paths != null) {
            this.paths.clear();
        }
        if (paths != null) {
            for (String item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    @Override
    public A addNewPath(String arg1) {
        return this.addToPaths(new String(arg1));
    }

    @Override
    public A addNewPath(StringBuilder arg1) {
        return this.addToPaths(new String(arg1));
    }

    @Override
    public A addNewPath(StringBuffer arg1) {
        return this.addToPaths(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RootPathsFluentImpl that = (RootPathsFluentImpl)o;
        return !(this.paths != null ? !this.paths.equals(that.paths) : that.paths != null);
    }

    public int hashCode() {
        return Objects.hash(this.paths, super.hashCode());
    }
}

