/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_13;

import io.fabric8.kubernetes.api.builder.v4_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_13.Nested;
import io.fabric8.kubernetes.api.model.v4_13.EventSeries;
import io.fabric8.kubernetes.api.model.v4_13.EventSeriesFluent;
import io.fabric8.kubernetes.api.model.v4_13.MicroTime;
import io.fabric8.kubernetes.api.model.v4_13.MicroTimeBuilder;
import io.fabric8.kubernetes.api.model.v4_13.MicroTimeFluentImpl;
import java.util.Objects;

public class EventSeriesFluentImpl<A extends EventSeriesFluent<A>>
extends BaseFluent<A>
implements EventSeriesFluent<A> {
    private Integer count;
    private MicroTimeBuilder lastObservedTime;

    public EventSeriesFluentImpl() {
    }

    public EventSeriesFluentImpl(EventSeries instance) {
        this.withCount(instance.getCount());
        this.withLastObservedTime(instance.getLastObservedTime());
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public A withCount(Integer count) {
        this.count = count;
        return (A)this;
    }

    @Override
    public Boolean hasCount() {
        return this.count != null;
    }

    @Override
    @Deprecated
    public MicroTime getLastObservedTime() {
        return this.lastObservedTime != null ? this.lastObservedTime.build() : null;
    }

    @Override
    public MicroTime buildLastObservedTime() {
        return this.lastObservedTime != null ? this.lastObservedTime.build() : null;
    }

    @Override
    public A withLastObservedTime(MicroTime lastObservedTime) {
        this._visitables.get("lastObservedTime").remove(this.lastObservedTime);
        if (lastObservedTime != null) {
            this.lastObservedTime = new MicroTimeBuilder(lastObservedTime);
            this._visitables.get("lastObservedTime").add(this.lastObservedTime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastObservedTime() {
        return this.lastObservedTime != null;
    }

    @Override
    public A withNewLastObservedTime(String time) {
        return this.withLastObservedTime(new MicroTime(time));
    }

    @Override
    public EventSeriesFluent.LastObservedTimeNested<A> withNewLastObservedTime() {
        return new LastObservedTimeNestedImpl();
    }

    @Override
    public EventSeriesFluent.LastObservedTimeNested<A> withNewLastObservedTimeLike(MicroTime item) {
        return new LastObservedTimeNestedImpl(item);
    }

    @Override
    public EventSeriesFluent.LastObservedTimeNested<A> editLastObservedTime() {
        return this.withNewLastObservedTimeLike(this.getLastObservedTime());
    }

    @Override
    public EventSeriesFluent.LastObservedTimeNested<A> editOrNewLastObservedTime() {
        return this.withNewLastObservedTimeLike(this.getLastObservedTime() != null ? this.getLastObservedTime() : new MicroTimeBuilder().build());
    }

    @Override
    public EventSeriesFluent.LastObservedTimeNested<A> editOrNewLastObservedTimeLike(MicroTime item) {
        return this.withNewLastObservedTimeLike(this.getLastObservedTime() != null ? this.getLastObservedTime() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSeriesFluentImpl that = (EventSeriesFluentImpl)o;
        if (this.count != null ? !this.count.equals(that.count) : that.count != null) {
            return false;
        }
        return !(this.lastObservedTime != null ? !this.lastObservedTime.equals(that.lastObservedTime) : that.lastObservedTime != null);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.lastObservedTime, super.hashCode());
    }

    public class LastObservedTimeNestedImpl<N>
    extends MicroTimeFluentImpl<EventSeriesFluent.LastObservedTimeNested<N>>
    implements EventSeriesFluent.LastObservedTimeNested<N>,
    Nested<N> {
        private final MicroTimeBuilder builder;

        LastObservedTimeNestedImpl(MicroTime item) {
            this.builder = new MicroTimeBuilder(this, item);
        }

        LastObservedTimeNestedImpl() {
            this.builder = new MicroTimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventSeriesFluentImpl.this.withLastObservedTime(this.builder.build());
        }

        @Override
        public N endLastObservedTime() {
            return this.and();
        }
    }
}

