/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_13.handlers;

import io.fabric8.kubernetes.api.model.v4_13.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_13.ListOptions;
import io.fabric8.kubernetes.clnt.v4_13.Config;
import io.fabric8.kubernetes.clnt.v4_13.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_13.Watch;
import io.fabric8.kubernetes.clnt.v4_13.Watcher;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Resource;
import io.fabric8.openshift.api.model.v4_13.Infrastructure;
import io.fabric8.openshift.api.model.v4_13.InfrastructureBuilder;
import io.fabric8.openshift.clnt.v4_13.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_13.dsl.internal.InfrastructureOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class InfrastructureHandler
implements ResourceHandler<Infrastructure, InfrastructureBuilder> {
    @Override
    public String getKind() {
        return Infrastructure.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    @Override
    public Infrastructure create(OkHttpClient client, Config config, String namespace, Infrastructure item) {
        return (Infrastructure)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Infrastructure[0]);
    }

    @Override
    public Infrastructure replace(OkHttpClient client, Config config, String namespace, Infrastructure item) {
        return (Infrastructure)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Infrastructure reload(OkHttpClient client, Config config, String namespace, Infrastructure item) {
        return (Infrastructure)((Gettable)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public InfrastructureBuilder edit(Infrastructure item) {
        return new InfrastructureBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Infrastructure item) {
        return (Boolean)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Infrastructure item, Watcher<Infrastructure> watcher) {
        return (Watch)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Infrastructure item, String resourceVersion, Watcher<Infrastructure> watcher) {
        return (Watch)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Infrastructure item, ListOptions options, Watcher<Infrastructure> watcher) {
        return (Watch)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Infrastructure waitUntilReady(OkHttpClient client, Config config, String namespace, Infrastructure item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Infrastructure)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Infrastructure waitUntilCondition(OkHttpClient client, Config config, String namespace, Infrastructure item, Predicate<Infrastructure> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Infrastructure)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

