/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_13.handlers;

import io.fabric8.kubernetes.api.model.v4_13.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_13.ListOptions;
import io.fabric8.kubernetes.clnt.v4_13.Config;
import io.fabric8.kubernetes.clnt.v4_13.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_13.Watch;
import io.fabric8.kubernetes.clnt.v4_13.Watcher;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Resource;
import io.fabric8.openshift.api.model.v4_13.operator.v1.Etcd;
import io.fabric8.openshift.api.model.v4_13.operator.v1.EtcdBuilder;
import io.fabric8.openshift.clnt.v4_13.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_13.dsl.internal.EtcdOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class EtcdHandler
implements ResourceHandler<Etcd, EtcdBuilder> {
    @Override
    public String getKind() {
        return Etcd.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "operator.openshift.io/v1";
    }

    @Override
    public Etcd create(OkHttpClient client, Config config, String namespace, Etcd item) {
        return (Etcd)new EtcdOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Etcd[0]);
    }

    @Override
    public Etcd replace(OkHttpClient client, Config config, String namespace, Etcd item) {
        return (Etcd)((Resource)new EtcdOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Etcd reload(OkHttpClient client, Config config, String namespace, Etcd item) {
        return (Etcd)((Gettable)((Resource)new EtcdOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public EtcdBuilder edit(Etcd item) {
        return new EtcdBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Etcd item) {
        return (Boolean)new EtcdOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Etcd item, Watcher<Etcd> watcher) {
        return (Watch)((Resource)new EtcdOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Etcd item, String resourceVersion, Watcher<Etcd> watcher) {
        return (Watch)((Resource)new EtcdOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Etcd item, ListOptions options, Watcher<Etcd> watcher) {
        return (Watch)((Resource)new EtcdOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Etcd waitUntilReady(OkHttpClient client, Config config, String namespace, Etcd item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Etcd)((Resource)new EtcdOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Etcd waitUntilCondition(OkHttpClient client, Config config, String namespace, Etcd item, Predicate<Etcd> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Etcd)((Resource)new EtcdOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

