/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_13;

import io.fabric8.kubernetes.clnt.v4_13.Config;
import io.fabric8.kubernetes.clnt.v4_13.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Createable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Namespaceable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_13.dsl.base.OperationSupport;
import io.fabric8.openshift.api.model.v4_13.DoneableLocalSubjectAccessReview;
import io.fabric8.openshift.api.model.v4_13.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.v4_13.SubjectAccessReviewResponse;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;

public class OpenShiftLocalSubjectAccessReviewOperationsImpl
extends OperationSupport
implements Createable<LocalSubjectAccessReview, SubjectAccessReviewResponse, DoneableLocalSubjectAccessReview>,
Namespaceable<OpenShiftLocalSubjectAccessReviewOperationsImpl> {
    private final String subjectAccessApiGroupName;
    private final String subjectAccessApiGroupVersion;
    private final String plural;

    public OpenShiftLocalSubjectAccessReviewOperationsImpl(OkHttpClient client, Config config, String apiGroupName, String apiGroupVersion, String plural) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config), apiGroupName, apiGroupVersion, plural);
    }

    public OpenShiftLocalSubjectAccessReviewOperationsImpl(OperationContext context, String apiGroupName, String apiGroupVersion, String plural) {
        super(context.withApiGroupName(apiGroupName).withApiGroupVersion(apiGroupVersion).withPlural(plural));
        this.subjectAccessApiGroupName = apiGroupName;
        this.subjectAccessApiGroupVersion = apiGroupVersion;
        this.plural = plural;
    }

    @Override
    public SubjectAccessReviewResponse create(LocalSubjectAccessReview ... resources) {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return this.handleCreate(this.updateApiVersion(resources[0]), SubjectAccessReviewResponse.class);
            }
            if (this.getItem() == null) {
                throw new IllegalArgumentException("Nothing to create.");
            }
            return this.handleCreate(this.updateApiVersion(this.getItem()), SubjectAccessReviewResponse.class);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(ie);
        }
    }

    @Override
    public SubjectAccessReviewResponse create(LocalSubjectAccessReview item) {
        try {
            return this.handleCreate(item, SubjectAccessReviewResponse.class);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(ie);
        }
    }

    @Override
    public DoneableLocalSubjectAccessReview createNew() {
        throw new IllegalStateException("This operation is not currently supported");
    }

    @Override
    public OpenShiftLocalSubjectAccessReviewOperationsImpl inNamespace(String namespace) {
        this.namespace = namespace;
        return new OpenShiftLocalSubjectAccessReviewOperationsImpl(this.context.withNamespace(namespace), this.subjectAccessApiGroupName, this.subjectAccessApiGroupVersion, this.plural);
    }

    private LocalSubjectAccessReview updateApiVersion(LocalSubjectAccessReview p) {
        if (p.getApiVersion() == null) {
            p.setApiVersion(this.apiGroupVersion);
        }
        return p;
    }

    public LocalSubjectAccessReview getItem() {
        return (LocalSubjectAccessReview)this.context.getItem();
    }
}

