/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_13.operator.v1;

import io.fabric8.kubernetes.api.builder.v4_13.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_13.operator.v1.Network;
import io.fabric8.openshift.api.model.v4_13.operator.v1.NetworkFluent;
import io.fabric8.openshift.api.model.v4_13.operator.v1.NetworkFluentImpl;
import java.util.Objects;

public class NetworkBuilder
extends NetworkFluentImpl<NetworkBuilder>
implements VisitableBuilder<Network, NetworkBuilder> {
    NetworkFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkBuilder() {
        this(true);
    }

    public NetworkBuilder(Boolean validationEnabled) {
        this(new Network(), validationEnabled);
    }

    public NetworkBuilder(NetworkFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkBuilder(NetworkFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Network(), validationEnabled);
    }

    public NetworkBuilder(NetworkFluent<?> fluent, Network instance) {
        this(fluent, instance, true);
    }

    public NetworkBuilder(NetworkFluent<?> fluent, Network instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public NetworkBuilder(Network instance) {
        this(instance, (Boolean)true);
    }

    public NetworkBuilder(Network instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Network build() {
        Network buildable = new Network(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkBuilder that = (NetworkBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

