/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_13.utils;

import io.fabric8.kubernetes.api.model.v4_13.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_13.HasMetadata;
import io.fabric8.kubernetes.clnt.v4_13.Config;
import io.fabric8.kubernetes.clnt.v4_13.HasMetadataVisitiableBuilder;
import io.fabric8.kubernetes.clnt.v4_13.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_13.ResourceHandler;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import okhttp3.OkHttpClient;

public class DeleteAndCreateHelper<T extends HasMetadata> {
    private final UnaryOperator<T> createTask;
    private final Function<T, Boolean> deleteTask;

    public DeleteAndCreateHelper(UnaryOperator<T> createTask, Function<T, Boolean> deleteTask) {
        this.createTask = createTask;
        this.deleteTask = deleteTask;
    }

    public T deleteAndCreate(T item) {
        Boolean deleted = this.deleteTask.apply(item);
        if (Boolean.FALSE.equals(deleted)) {
            throw new KubernetesClientException("Failed to delete existing item:" + item.getMetadata().getName());
        }
        return (T)((HasMetadata)this.createTask.apply(item));
    }

    public static HasMetadata deleteAndCreateItem(OkHttpClient client, Config config, HasMetadata meta, ResourceHandler<HasMetadata, HasMetadataVisitiableBuilder> h, String namespaceToUse, DeletionPropagation propagationPolicy) {
        DeleteAndCreateHelper<HasMetadata> deleteAndCreateHelper = new DeleteAndCreateHelper<HasMetadata>(m -> h.create(client, config, namespaceToUse, (HasMetadata)m), m -> h.delete(client, config, namespaceToUse, propagationPolicy, (HasMetadata)m));
        return deleteAndCreateHelper.deleteAndCreate(meta);
    }
}

