/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_13.dsl.internal;

import io.fabric8.kubernetes.clnt.v4_13.Config;
import io.fabric8.kubernetes.clnt.v4_13.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_13.VersionInfo;
import io.fabric8.kubernetes.clnt.v4_13.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_13.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v4_13.utils.Serialization;
import io.fabric8.kubernetes.clnt.v4_13.utils.URLUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ClusterOperationsImpl
extends OperationSupport {
    protected final String versionEndpoint;
    public static final String KUBERNETES_VERSION_ENDPOINT = "version";

    public ClusterOperationsImpl(OkHttpClient client, Config config, String item) {
        super(new OperationContext().withOkhttpClient(client).withConfig(config));
        this.versionEndpoint = item;
    }

    public VersionInfo fetchVersion() {
        try {
            Response response = this.handleVersionGet(this.versionEndpoint);
            Map<String, String> myMap = new HashMap<String, String>();
            if (response.body() != null) {
                myMap = (Map)Serialization.jsonMapper().readValue(response.body().string(), HashMap.class);
            }
            return ClusterOperationsImpl.fetchVersionInfoFromResponse(myMap);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    protected Response handleVersionGet(String versionEndpointToBeUsed) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().get().url(URLUtils.join(this.config.getMasterUrl(), versionEndpointToBeUsed));
        return this.client.newCall(requestBuilder.build()).execute();
    }

    protected static VersionInfo fetchVersionInfoFromResponse(Map<String, String> responseAsMap) throws ParseException {
        return new VersionInfo.Builder().withBuildDate(responseAsMap.get("buildDate")).withGitCommit(responseAsMap.get("gitCommit")).withGitVersion(responseAsMap.get("gitVersion")).withMajor(responseAsMap.get("major")).withMinor(responseAsMap.get("minor")).withGitTreeState(responseAsMap.get("gitTreeState")).withPlatform(responseAsMap.get("platform")).withGoVersion(responseAsMap.get("goVersion")).withCompiler(responseAsMap.get("compiler")).build();
    }
}

