/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_13.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.v4_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_13.Predicate;
import io.fabric8.kubernetes.api.model.v4_13.authorization.v1beta1.NonResourceRule;
import io.fabric8.kubernetes.api.model.v4_13.authorization.v1beta1.NonResourceRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class NonResourceRuleFluentImpl<A extends NonResourceRuleFluent<A>>
extends BaseFluent<A>
implements NonResourceRuleFluent<A> {
    private List<String> nonResourceURLs = new ArrayList<String>();
    private List<String> verbs = new ArrayList<String>();

    public NonResourceRuleFluentImpl() {
    }

    public NonResourceRuleFluentImpl(NonResourceRule instance) {
        this.withNonResourceURLs(instance.getNonResourceURLs());
        this.withVerbs(instance.getVerbs());
    }

    @Override
    public A addToNonResourceURLs(int index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNonResourceURLs(int index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNonResourceURLs(String ... items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNonResourceURLs(Collection<String> items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNonResourceURLs(String ... items) {
        for (String item : items) {
            if (this.nonResourceURLs == null) continue;
            this.nonResourceURLs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNonResourceURLs(Collection<String> items) {
        for (String item : items) {
            if (this.nonResourceURLs == null) continue;
            this.nonResourceURLs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNonResourceURLs() {
        return this.nonResourceURLs;
    }

    @Override
    public String getNonResourceURL(int index) {
        return this.nonResourceURLs.get(index);
    }

    @Override
    public String getFirstNonResourceURL() {
        return this.nonResourceURLs.get(0);
    }

    @Override
    public String getLastNonResourceURL() {
        return this.nonResourceURLs.get(this.nonResourceURLs.size() - 1);
    }

    @Override
    public String getMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNonResourceURLs(List<String> nonResourceURLs) {
        if (this.nonResourceURLs != null) {
            this._visitables.get("nonResourceURLs").removeAll(this.nonResourceURLs);
        }
        if (nonResourceURLs != null) {
            this.nonResourceURLs = new ArrayList<String>();
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        } else {
            this.nonResourceURLs = null;
        }
        return (A)this;
    }

    @Override
    public A withNonResourceURLs(String ... nonResourceURLs) {
        if (this.nonResourceURLs != null) {
            this.nonResourceURLs.clear();
        }
        if (nonResourceURLs != null) {
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNonResourceURLs() {
        return this.nonResourceURLs != null && !this.nonResourceURLs.isEmpty();
    }

    @Override
    public A addNewNonResourceURL(String arg1) {
        return this.addToNonResourceURLs(new String(arg1));
    }

    @Override
    public A addNewNonResourceURL(StringBuilder arg1) {
        return this.addToNonResourceURLs(new String(arg1));
    }

    @Override
    public A addNewNonResourceURL(StringBuffer arg1) {
        return this.addToNonResourceURLs(new String(arg1));
    }

    @Override
    public A addToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVerbs(String ... items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVerbs(Collection<String> items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVerbs(String ... items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVerbs(Collection<String> items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVerbs() {
        return this.verbs;
    }

    @Override
    public String getVerb(int index) {
        return this.verbs.get(index);
    }

    @Override
    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    @Override
    public String getLastVerb() {
        return this.verbs.get(this.verbs.size() - 1);
    }

    @Override
    public String getMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVerbs(List<String> verbs) {
        if (this.verbs != null) {
            this._visitables.get("verbs").removeAll(this.verbs);
        }
        if (verbs != null) {
            this.verbs = new ArrayList<String>();
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        } else {
            this.verbs = null;
        }
        return (A)this;
    }

    @Override
    public A withVerbs(String ... verbs) {
        if (this.verbs != null) {
            this.verbs.clear();
        }
        if (verbs != null) {
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVerbs() {
        return this.verbs != null && !this.verbs.isEmpty();
    }

    @Override
    public A addNewVerb(String arg1) {
        return this.addToVerbs(new String(arg1));
    }

    @Override
    public A addNewVerb(StringBuilder arg1) {
        return this.addToVerbs(new String(arg1));
    }

    @Override
    public A addNewVerb(StringBuffer arg1) {
        return this.addToVerbs(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NonResourceRuleFluentImpl that = (NonResourceRuleFluentImpl)o;
        if (this.nonResourceURLs != null ? !this.nonResourceURLs.equals(that.nonResourceURLs) : that.nonResourceURLs != null) {
            return false;
        }
        return !(this.verbs != null ? !this.verbs.equals(that.verbs) : that.verbs != null);
    }

    public int hashCode() {
        return Objects.hash(this.nonResourceURLs, this.verbs, super.hashCode());
    }
}

