/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_13;

import io.fabric8.kubernetes.api.builder.v4_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_13.Nested;
import io.fabric8.kubernetes.api.builder.v4_13.Predicate;
import io.fabric8.kubernetes.api.model.v4_13.ServicePort;
import io.fabric8.kubernetes.api.model.v4_13.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.v4_13.ServicePortFluentImpl;
import io.fabric8.kubernetes.api.model.v4_13.ServiceSpec;
import io.fabric8.kubernetes.api.model.v4_13.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.v4_13.SessionAffinityConfig;
import io.fabric8.kubernetes.api.model.v4_13.SessionAffinityConfigBuilder;
import io.fabric8.kubernetes.api.model.v4_13.SessionAffinityConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceSpecFluentImpl<A extends ServiceSpecFluent<A>>
extends BaseFluent<A>
implements ServiceSpecFluent<A> {
    private String clusterIP;
    private List<String> externalIPs = new ArrayList<String>();
    private String externalName;
    private String externalTrafficPolicy;
    private Integer healthCheckNodePort;
    private String ipFamily;
    private String loadBalancerIP;
    private List<String> loadBalancerSourceRanges = new ArrayList<String>();
    private List<ServicePortBuilder> ports = new ArrayList<ServicePortBuilder>();
    private Boolean publishNotReadyAddresses;
    private Map<String, String> selector;
    private String sessionAffinity;
    private SessionAffinityConfigBuilder sessionAffinityConfig;
    private List<String> topologyKeys = new ArrayList<String>();
    private String type;

    public ServiceSpecFluentImpl() {
    }

    public ServiceSpecFluentImpl(ServiceSpec instance) {
        this.withClusterIP(instance.getClusterIP());
        this.withExternalIPs(instance.getExternalIPs());
        this.withExternalName(instance.getExternalName());
        this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
        this.withHealthCheckNodePort(instance.getHealthCheckNodePort());
        this.withIpFamily(instance.getIpFamily());
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
        this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
        this.withPorts(instance.getPorts());
        this.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses());
        this.withSelector(instance.getSelector());
        this.withSessionAffinity(instance.getSessionAffinity());
        this.withSessionAffinityConfig(instance.getSessionAffinityConfig());
        this.withTopologyKeys(instance.getTopologyKeys());
        this.withType(instance.getType());
    }

    @Override
    public String getClusterIP() {
        return this.clusterIP;
    }

    @Override
    public A withClusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
        return (A)this;
    }

    @Override
    public Boolean hasClusterIP() {
        return this.clusterIP != null;
    }

    @Override
    public A withNewClusterIP(String arg1) {
        return this.withClusterIP(new String(arg1));
    }

    @Override
    public A withNewClusterIP(StringBuilder arg1) {
        return this.withClusterIP(new String(arg1));
    }

    @Override
    public A withNewClusterIP(StringBuffer arg1) {
        return this.withClusterIP(new String(arg1));
    }

    @Override
    public A addToExternalIPs(int index, String item) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        this.externalIPs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToExternalIPs(int index, String item) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        this.externalIPs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToExternalIPs(String ... items) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToExternalIPs(Collection<String> items) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromExternalIPs(String ... items) {
        for (String item : items) {
            if (this.externalIPs == null) continue;
            this.externalIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExternalIPs(Collection<String> items) {
        for (String item : items) {
            if (this.externalIPs == null) continue;
            this.externalIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getExternalIPs() {
        return this.externalIPs;
    }

    @Override
    public String getExternalIP(int index) {
        return this.externalIPs.get(index);
    }

    @Override
    public String getFirstExternalIP() {
        return this.externalIPs.get(0);
    }

    @Override
    public String getLastExternalIP() {
        return this.externalIPs.get(this.externalIPs.size() - 1);
    }

    @Override
    public String getMatchingExternalIP(Predicate<String> predicate) {
        for (String item : this.externalIPs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExternalIP(Predicate<String> predicate) {
        for (String item : this.externalIPs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExternalIPs(List<String> externalIPs) {
        if (this.externalIPs != null) {
            this._visitables.get("externalIPs").removeAll(this.externalIPs);
        }
        if (externalIPs != null) {
            this.externalIPs = new ArrayList<String>();
            for (String item : externalIPs) {
                this.addToExternalIPs(item);
            }
        } else {
            this.externalIPs = null;
        }
        return (A)this;
    }

    @Override
    public A withExternalIPs(String ... externalIPs) {
        if (this.externalIPs != null) {
            this.externalIPs.clear();
        }
        if (externalIPs != null) {
            for (String item : externalIPs) {
                this.addToExternalIPs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExternalIPs() {
        return this.externalIPs != null && !this.externalIPs.isEmpty();
    }

    @Override
    public A addNewExternalIP(String arg1) {
        return this.addToExternalIPs(new String(arg1));
    }

    @Override
    public A addNewExternalIP(StringBuilder arg1) {
        return this.addToExternalIPs(new String(arg1));
    }

    @Override
    public A addNewExternalIP(StringBuffer arg1) {
        return this.addToExternalIPs(new String(arg1));
    }

    @Override
    public String getExternalName() {
        return this.externalName;
    }

    @Override
    public A withExternalName(String externalName) {
        this.externalName = externalName;
        return (A)this;
    }

    @Override
    public Boolean hasExternalName() {
        return this.externalName != null;
    }

    @Override
    public A withNewExternalName(String arg1) {
        return this.withExternalName(new String(arg1));
    }

    @Override
    public A withNewExternalName(StringBuilder arg1) {
        return this.withExternalName(new String(arg1));
    }

    @Override
    public A withNewExternalName(StringBuffer arg1) {
        return this.withExternalName(new String(arg1));
    }

    @Override
    public String getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    @Override
    public A withExternalTrafficPolicy(String externalTrafficPolicy) {
        this.externalTrafficPolicy = externalTrafficPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasExternalTrafficPolicy() {
        return this.externalTrafficPolicy != null;
    }

    @Override
    public A withNewExternalTrafficPolicy(String arg1) {
        return this.withExternalTrafficPolicy(new String(arg1));
    }

    @Override
    public A withNewExternalTrafficPolicy(StringBuilder arg1) {
        return this.withExternalTrafficPolicy(new String(arg1));
    }

    @Override
    public A withNewExternalTrafficPolicy(StringBuffer arg1) {
        return this.withExternalTrafficPolicy(new String(arg1));
    }

    @Override
    public Integer getHealthCheckNodePort() {
        return this.healthCheckNodePort;
    }

    @Override
    public A withHealthCheckNodePort(Integer healthCheckNodePort) {
        this.healthCheckNodePort = healthCheckNodePort;
        return (A)this;
    }

    @Override
    public Boolean hasHealthCheckNodePort() {
        return this.healthCheckNodePort != null;
    }

    @Override
    public String getIpFamily() {
        return this.ipFamily;
    }

    @Override
    public A withIpFamily(String ipFamily) {
        this.ipFamily = ipFamily;
        return (A)this;
    }

    @Override
    public Boolean hasIpFamily() {
        return this.ipFamily != null;
    }

    @Override
    public A withNewIpFamily(String arg1) {
        return this.withIpFamily(new String(arg1));
    }

    @Override
    public A withNewIpFamily(StringBuilder arg1) {
        return this.withIpFamily(new String(arg1));
    }

    @Override
    public A withNewIpFamily(StringBuffer arg1) {
        return this.withIpFamily(new String(arg1));
    }

    @Override
    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    @Override
    public A withLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
        return (A)this;
    }

    @Override
    public Boolean hasLoadBalancerIP() {
        return this.loadBalancerIP != null;
    }

    @Override
    public A withNewLoadBalancerIP(String arg1) {
        return this.withLoadBalancerIP(new String(arg1));
    }

    @Override
    public A withNewLoadBalancerIP(StringBuilder arg1) {
        return this.withLoadBalancerIP(new String(arg1));
    }

    @Override
    public A withNewLoadBalancerIP(StringBuffer arg1) {
        return this.withLoadBalancerIP(new String(arg1));
    }

    @Override
    public A addToLoadBalancerSourceRanges(int index, String item) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        this.loadBalancerSourceRanges.add(index, item);
        return (A)this;
    }

    @Override
    public A setToLoadBalancerSourceRanges(int index, String item) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        this.loadBalancerSourceRanges.set(index, item);
        return (A)this;
    }

    @Override
    public A addToLoadBalancerSourceRanges(String ... items) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToLoadBalancerSourceRanges(Collection<String> items) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromLoadBalancerSourceRanges(String ... items) {
        for (String item : items) {
            if (this.loadBalancerSourceRanges == null) continue;
            this.loadBalancerSourceRanges.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLoadBalancerSourceRanges(Collection<String> items) {
        for (String item : items) {
            if (this.loadBalancerSourceRanges == null) continue;
            this.loadBalancerSourceRanges.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    @Override
    public String getLoadBalancerSourceRange(int index) {
        return this.loadBalancerSourceRanges.get(index);
    }

    @Override
    public String getFirstLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(0);
    }

    @Override
    public String getLastLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(this.loadBalancerSourceRanges.size() - 1);
    }

    @Override
    public String getMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item : this.loadBalancerSourceRanges) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item : this.loadBalancerSourceRanges) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) {
            this._visitables.get("loadBalancerSourceRanges").removeAll(this.loadBalancerSourceRanges);
        }
        if (loadBalancerSourceRanges != null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
            for (String item : loadBalancerSourceRanges) {
                this.addToLoadBalancerSourceRanges(item);
            }
        } else {
            this.loadBalancerSourceRanges = null;
        }
        return (A)this;
    }

    @Override
    public A withLoadBalancerSourceRanges(String ... loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) {
            this.loadBalancerSourceRanges.clear();
        }
        if (loadBalancerSourceRanges != null) {
            for (String item : loadBalancerSourceRanges) {
                this.addToLoadBalancerSourceRanges(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges != null && !this.loadBalancerSourceRanges.isEmpty();
    }

    @Override
    public A addNewLoadBalancerSourceRange(String arg1) {
        return this.addToLoadBalancerSourceRanges(new String(arg1));
    }

    @Override
    public A addNewLoadBalancerSourceRange(StringBuilder arg1) {
        return this.addToLoadBalancerSourceRanges(new String(arg1));
    }

    @Override
    public A addNewLoadBalancerSourceRange(StringBuffer arg1) {
        return this.addToLoadBalancerSourceRanges(new String(arg1));
    }

    @Override
    public A addToPorts(int index, ServicePort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<ServicePortBuilder>();
        }
        ServicePortBuilder builder = new ServicePortBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, ServicePort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<ServicePortBuilder>();
        }
        ServicePortBuilder builder = new ServicePortBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(ServicePort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<ServicePortBuilder>();
        }
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<ServicePort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<ServicePortBuilder>();
        }
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(ServicePort ... items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<ServicePort> items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<ServicePortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<ServicePortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            ServicePortBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServicePort> getPorts() {
        return ServiceSpecFluentImpl.build(this.ports);
    }

    @Override
    public List<ServicePort> buildPorts() {
        return ServiceSpecFluentImpl.build(this.ports);
    }

    @Override
    public ServicePort buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public ServicePort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public ServicePort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public ServicePort buildMatchingPort(Predicate<ServicePortBuilder> predicate) {
        for (ServicePortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<ServicePortBuilder> predicate) {
        for (ServicePortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<ServicePort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<ServicePortBuilder>();
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(ServicePort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> addNewPortLike(ServicePort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> setNewPortLike(int index, ServicePort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> editMatchingPort(Predicate<ServicePortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply(this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public Boolean isPublishNotReadyAddresses() {
        return this.publishNotReadyAddresses;
    }

    @Override
    public A withPublishNotReadyAddresses(Boolean publishNotReadyAddresses) {
        this.publishNotReadyAddresses = publishNotReadyAddresses;
        return (A)this;
    }

    @Override
    public Boolean hasPublishNotReadyAddresses() {
        return this.publishNotReadyAddresses != null;
    }

    @Override
    public A withNewPublishNotReadyAddresses(String arg1) {
        return this.withPublishNotReadyAddresses(new Boolean(arg1));
    }

    @Override
    public A withNewPublishNotReadyAddresses(boolean arg1) {
        return this.withPublishNotReadyAddresses(new Boolean(arg1));
    }

    @Override
    public A addToSelector(String key, String value) {
        if (this.selector == null && key != null && value != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSelector(Map<String, String> map) {
        if (this.selector == null && map != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(String key) {
        if (this.selector == null) {
            return (A)this;
        }
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(Map<String, String> map) {
        if (this.selector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(Map<String, String> selector) {
        this.selector = selector == null ? null : new LinkedHashMap<String, String>(selector);
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    @Override
    public A withSessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return (A)this;
    }

    @Override
    public Boolean hasSessionAffinity() {
        return this.sessionAffinity != null;
    }

    @Override
    public A withNewSessionAffinity(String arg1) {
        return this.withSessionAffinity(new String(arg1));
    }

    @Override
    public A withNewSessionAffinity(StringBuilder arg1) {
        return this.withSessionAffinity(new String(arg1));
    }

    @Override
    public A withNewSessionAffinity(StringBuffer arg1) {
        return this.withSessionAffinity(new String(arg1));
    }

    @Override
    @Deprecated
    public SessionAffinityConfig getSessionAffinityConfig() {
        return this.sessionAffinityConfig != null ? this.sessionAffinityConfig.build() : null;
    }

    @Override
    public SessionAffinityConfig buildSessionAffinityConfig() {
        return this.sessionAffinityConfig != null ? this.sessionAffinityConfig.build() : null;
    }

    @Override
    public A withSessionAffinityConfig(SessionAffinityConfig sessionAffinityConfig) {
        this._visitables.get("sessionAffinityConfig").remove(this.sessionAffinityConfig);
        if (sessionAffinityConfig != null) {
            this.sessionAffinityConfig = new SessionAffinityConfigBuilder(sessionAffinityConfig);
            this._visitables.get("sessionAffinityConfig").add(this.sessionAffinityConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSessionAffinityConfig() {
        return this.sessionAffinityConfig != null;
    }

    @Override
    public ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfig() {
        return new SessionAffinityConfigNestedImpl();
    }

    @Override
    public ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfigLike(SessionAffinityConfig item) {
        return new SessionAffinityConfigNestedImpl(item);
    }

    @Override
    public ServiceSpecFluent.SessionAffinityConfigNested<A> editSessionAffinityConfig() {
        return this.withNewSessionAffinityConfigLike(this.getSessionAffinityConfig());
    }

    @Override
    public ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfig() {
        return this.withNewSessionAffinityConfigLike(this.getSessionAffinityConfig() != null ? this.getSessionAffinityConfig() : new SessionAffinityConfigBuilder().build());
    }

    @Override
    public ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfigLike(SessionAffinityConfig item) {
        return this.withNewSessionAffinityConfigLike(this.getSessionAffinityConfig() != null ? this.getSessionAffinityConfig() : item);
    }

    @Override
    public A addToTopologyKeys(int index, String item) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTopologyKeys(int index, String item) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTopologyKeys(String ... items) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyKeys.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopologyKeys(Collection<String> items) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyKeys.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopologyKeys(String ... items) {
        for (String item : items) {
            if (this.topologyKeys == null) continue;
            this.topologyKeys.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopologyKeys(Collection<String> items) {
        for (String item : items) {
            if (this.topologyKeys == null) continue;
            this.topologyKeys.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTopologyKeys() {
        return this.topologyKeys;
    }

    @Override
    public String getTopologyKey(int index) {
        return this.topologyKeys.get(index);
    }

    @Override
    public String getFirstTopologyKey() {
        return this.topologyKeys.get(0);
    }

    @Override
    public String getLastTopologyKey() {
        return this.topologyKeys.get(this.topologyKeys.size() - 1);
    }

    @Override
    public String getMatchingTopologyKey(Predicate<String> predicate) {
        for (String item : this.topologyKeys) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopologyKey(Predicate<String> predicate) {
        for (String item : this.topologyKeys) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopologyKeys(List<String> topologyKeys) {
        if (this.topologyKeys != null) {
            this._visitables.get("topologyKeys").removeAll(this.topologyKeys);
        }
        if (topologyKeys != null) {
            this.topologyKeys = new ArrayList<String>();
            for (String item : topologyKeys) {
                this.addToTopologyKeys(item);
            }
        } else {
            this.topologyKeys = null;
        }
        return (A)this;
    }

    @Override
    public A withTopologyKeys(String ... topologyKeys) {
        if (this.topologyKeys != null) {
            this.topologyKeys.clear();
        }
        if (topologyKeys != null) {
            for (String item : topologyKeys) {
                this.addToTopologyKeys(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopologyKeys() {
        return this.topologyKeys != null && !this.topologyKeys.isEmpty();
    }

    @Override
    public A addNewTopologyKey(String arg1) {
        return this.addToTopologyKeys(new String(arg1));
    }

    @Override
    public A addNewTopologyKey(StringBuilder arg1) {
        return this.addToTopologyKeys(new String(arg1));
    }

    @Override
    public A addNewTopologyKey(StringBuffer arg1) {
        return this.addToTopologyKeys(new String(arg1));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public A withNewType(String arg1) {
        return this.withType(new String(arg1));
    }

    @Override
    public A withNewType(StringBuilder arg1) {
        return this.withType(new String(arg1));
    }

    @Override
    public A withNewType(StringBuffer arg1) {
        return this.withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecFluentImpl that = (ServiceSpecFluentImpl)o;
        if (this.clusterIP != null ? !this.clusterIP.equals(that.clusterIP) : that.clusterIP != null) {
            return false;
        }
        if (this.externalIPs != null ? !this.externalIPs.equals(that.externalIPs) : that.externalIPs != null) {
            return false;
        }
        if (this.externalName != null ? !this.externalName.equals(that.externalName) : that.externalName != null) {
            return false;
        }
        if (this.externalTrafficPolicy != null ? !this.externalTrafficPolicy.equals(that.externalTrafficPolicy) : that.externalTrafficPolicy != null) {
            return false;
        }
        if (this.healthCheckNodePort != null ? !this.healthCheckNodePort.equals(that.healthCheckNodePort) : that.healthCheckNodePort != null) {
            return false;
        }
        if (this.ipFamily != null ? !this.ipFamily.equals(that.ipFamily) : that.ipFamily != null) {
            return false;
        }
        if (this.loadBalancerIP != null ? !this.loadBalancerIP.equals(that.loadBalancerIP) : that.loadBalancerIP != null) {
            return false;
        }
        if (this.loadBalancerSourceRanges != null ? !this.loadBalancerSourceRanges.equals(that.loadBalancerSourceRanges) : that.loadBalancerSourceRanges != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.publishNotReadyAddresses != null ? !this.publishNotReadyAddresses.equals(that.publishNotReadyAddresses) : that.publishNotReadyAddresses != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.sessionAffinity != null ? !this.sessionAffinity.equals(that.sessionAffinity) : that.sessionAffinity != null) {
            return false;
        }
        if (this.sessionAffinityConfig != null ? !this.sessionAffinityConfig.equals(that.sessionAffinityConfig) : that.sessionAffinityConfig != null) {
            return false;
        }
        if (this.topologyKeys != null ? !this.topologyKeys.equals(that.topologyKeys) : that.topologyKeys != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        return Objects.hash(this.clusterIP, this.externalIPs, this.externalName, this.externalTrafficPolicy, this.healthCheckNodePort, this.ipFamily, this.loadBalancerIP, this.loadBalancerSourceRanges, this.ports, this.publishNotReadyAddresses, this.selector, this.sessionAffinity, this.sessionAffinityConfig, this.topologyKeys, this.type, super.hashCode());
    }

    public class SessionAffinityConfigNestedImpl<N>
    extends SessionAffinityConfigFluentImpl<ServiceSpecFluent.SessionAffinityConfigNested<N>>
    implements ServiceSpecFluent.SessionAffinityConfigNested<N>,
    Nested<N> {
        private final SessionAffinityConfigBuilder builder;

        SessionAffinityConfigNestedImpl(SessionAffinityConfig item) {
            this.builder = new SessionAffinityConfigBuilder(this, item);
        }

        SessionAffinityConfigNestedImpl() {
            this.builder = new SessionAffinityConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceSpecFluentImpl.this.withSessionAffinityConfig(this.builder.build());
        }

        @Override
        public N endSessionAffinityConfig() {
            return this.and();
        }
    }

    public class PortsNestedImpl<N>
    extends ServicePortFluentImpl<ServiceSpecFluent.PortsNested<N>>
    implements ServiceSpecFluent.PortsNested<N>,
    Nested<N> {
        private final ServicePortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, ServicePort item) {
            this.index = index;
            this.builder = new ServicePortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new ServicePortBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceSpecFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

