/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_13;

import io.fabric8.kubernetes.api.builder.v4_13.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_13.Probe;
import io.fabric8.kubernetes.api.model.v4_13.ProbeFluent;
import io.fabric8.kubernetes.api.model.v4_13.ProbeFluentImpl;
import java.util.Objects;

public class ProbeBuilder
extends ProbeFluentImpl<ProbeBuilder>
implements VisitableBuilder<Probe, ProbeBuilder> {
    ProbeFluent<?> fluent;
    Boolean validationEnabled;

    public ProbeBuilder() {
        this(true);
    }

    public ProbeBuilder(Boolean validationEnabled) {
        this(new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance) {
        this(fluent, instance, true);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withExec(instance.getExec());
        fluent.withFailureThreshold(instance.getFailureThreshold());
        fluent.withHttpGet(instance.getHttpGet());
        fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        fluent.withPeriodSeconds(instance.getPeriodSeconds());
        fluent.withSuccessThreshold(instance.getSuccessThreshold());
        fluent.withTcpSocket(instance.getTcpSocket());
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validationEnabled = validationEnabled;
    }

    public ProbeBuilder(Probe instance) {
        this(instance, (Boolean)true);
    }

    public ProbeBuilder(Probe instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withExec(instance.getExec());
        this.withFailureThreshold(instance.getFailureThreshold());
        this.withHttpGet(instance.getHttpGet());
        this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        this.withPeriodSeconds(instance.getPeriodSeconds());
        this.withSuccessThreshold(instance.getSuccessThreshold());
        this.withTcpSocket(instance.getTcpSocket());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Probe build() {
        Probe buildable = new Probe(this.fluent.getExec(), this.fluent.getFailureThreshold(), this.fluent.getHttpGet(), this.fluent.getInitialDelaySeconds(), this.fluent.getPeriodSeconds(), this.fluent.getSuccessThreshold(), this.fluent.getTcpSocket(), this.fluent.getTimeoutSeconds());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProbeBuilder that = (ProbeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

