/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.internal.readiness;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;

public class OpenShiftReadiness
extends Readiness {
    public static boolean isReady(HasMetadata item) {
        if (Readiness.isReadiableKubernetesResource(item)) {
            return Readiness.isReady(item);
        }
        if (item instanceof DeploymentConfig) {
            return OpenShiftReadiness.isDeploymentConfigReady((DeploymentConfig)item);
        }
        throw new IllegalArgumentException("Item needs to be one of [Node, Deployment, ReplicaSet, StatefulSet, Pod, DeploymentConfig, ReplicationController], but was: [" + (item != null ? item.getKind() : "Unknown (null)") + "]");
    }

    public static boolean isDeploymentConfigReady(DeploymentConfig d) {
        Utils.checkNotNull(d, "Deployment can't be null.");
        DeploymentConfigSpec spec = d.getSpec();
        DeploymentConfigStatus status = d.getStatus();
        if (status == null || status.getReplicas() == null || status.getAvailableReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas() <= status.getAvailableReplicas();
    }
}

