/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyEgressRule;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyEgressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPeer;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPeerBuilder;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPeerFluentImpl;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPort;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPortBuilder;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPortFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class NetworkPolicyEgressRuleFluentImpl<A extends NetworkPolicyEgressRuleFluent<A>>
extends BaseFluent<A>
implements NetworkPolicyEgressRuleFluent<A> {
    private List<NetworkPolicyPortBuilder> ports = new ArrayList<NetworkPolicyPortBuilder>();
    private List<NetworkPolicyPeerBuilder> to = new ArrayList<NetworkPolicyPeerBuilder>();

    public NetworkPolicyEgressRuleFluentImpl() {
    }

    public NetworkPolicyEgressRuleFluentImpl(NetworkPolicyEgressRule instance) {
        this.withPorts(instance.getPorts());
        this.withTo(instance.getTo());
    }

    @Override
    public A addToPorts(int index, NetworkPolicyPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<NetworkPolicyPortBuilder>();
        }
        NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, NetworkPolicyPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<NetworkPolicyPortBuilder>();
        }
        NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(NetworkPolicyPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<NetworkPolicyPortBuilder>();
        }
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<NetworkPolicyPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<NetworkPolicyPortBuilder>();
        }
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(NetworkPolicyPort ... items) {
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<NetworkPolicyPort> items) {
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<NetworkPolicyPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<NetworkPolicyPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            NetworkPolicyPortBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NetworkPolicyPort> getPorts() {
        return NetworkPolicyEgressRuleFluentImpl.build(this.ports);
    }

    @Override
    public List<NetworkPolicyPort> buildPorts() {
        return NetworkPolicyEgressRuleFluentImpl.build(this.ports);
    }

    @Override
    public NetworkPolicyPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public NetworkPolicyPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public NetworkPolicyPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public NetworkPolicyPort buildMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
        for (NetworkPolicyPortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
        for (NetworkPolicyPortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<NetworkPolicyPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<NetworkPolicyPortBuilder>();
            for (NetworkPolicyPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(NetworkPolicyPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (NetworkPolicyPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> addNewPortLike(NetworkPolicyPort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> setNewPortLike(int index, NetworkPolicyPort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> editMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply(this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public A addToTo(int index, NetworkPolicyPeer item) {
        if (this.to == null) {
            this.to = new ArrayList<NetworkPolicyPeerBuilder>();
        }
        NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
        this._visitables.get("to").add(index >= 0 ? index : this._visitables.get("to").size(), builder);
        this.to.add(index >= 0 ? index : this.to.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTo(int index, NetworkPolicyPeer item) {
        if (this.to == null) {
            this.to = new ArrayList<NetworkPolicyPeerBuilder>();
        }
        NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
        if (index < 0 || index >= this._visitables.get("to").size()) {
            this._visitables.get("to").add(builder);
        } else {
            this._visitables.get("to").set(index, builder);
        }
        if (index < 0 || index >= this.to.size()) {
            this.to.add(builder);
        } else {
            this.to.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTo(NetworkPolicyPeer ... items) {
        if (this.to == null) {
            this.to = new ArrayList<NetworkPolicyPeerBuilder>();
        }
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTo(Collection<NetworkPolicyPeer> items) {
        if (this.to == null) {
            this.to = new ArrayList<NetworkPolicyPeerBuilder>();
        }
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTo(NetworkPolicyPeer ... items) {
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").remove(builder);
            if (this.to == null) continue;
            this.to.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTo(Collection<NetworkPolicyPeer> items) {
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").remove(builder);
            if (this.to == null) continue;
            this.to.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
        if (this.to == null) {
            return (A)this;
        }
        Iterator<NetworkPolicyPeerBuilder> each = this.to.iterator();
        Object visitables = this._visitables.get("to");
        while (each.hasNext()) {
            NetworkPolicyPeerBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NetworkPolicyPeer> getTo() {
        return NetworkPolicyEgressRuleFluentImpl.build(this.to);
    }

    @Override
    public List<NetworkPolicyPeer> buildTo() {
        return NetworkPolicyEgressRuleFluentImpl.build(this.to);
    }

    @Override
    public NetworkPolicyPeer buildTo(int index) {
        return this.to.get(index).build();
    }

    @Override
    public NetworkPolicyPeer buildFirstTo() {
        return this.to.get(0).build();
    }

    @Override
    public NetworkPolicyPeer buildLastTo() {
        return this.to.get(this.to.size() - 1).build();
    }

    @Override
    public NetworkPolicyPeer buildMatchingTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
        for (NetworkPolicyPeerBuilder item : this.to) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
        for (NetworkPolicyPeerBuilder item : this.to) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTo(List<NetworkPolicyPeer> to) {
        if (this.to != null) {
            this._visitables.get("to").removeAll(this.to);
        }
        if (to != null) {
            this.to = new ArrayList<NetworkPolicyPeerBuilder>();
            for (NetworkPolicyPeer item : to) {
                this.addToTo(item);
            }
        } else {
            this.to = null;
        }
        return (A)this;
    }

    @Override
    public A withTo(NetworkPolicyPeer ... to) {
        if (this.to != null) {
            this.to.clear();
        }
        if (to != null) {
            for (NetworkPolicyPeer item : to) {
                this.addToTo(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTo() {
        return this.to != null && !this.to.isEmpty();
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> addNewTo() {
        return new ToNestedImpl();
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> addNewToLike(NetworkPolicyPeer item) {
        return new ToNestedImpl(-1, item);
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> setNewToLike(int index, NetworkPolicyPeer item) {
        return new ToNestedImpl(index, item);
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> editTo(int index) {
        if (this.to.size() <= index) {
            throw new RuntimeException("Can't edit to. Index exceeds size.");
        }
        return this.setNewToLike(index, this.buildTo(index));
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> editFirstTo() {
        if (this.to.size() == 0) {
            throw new RuntimeException("Can't edit first to. The list is empty.");
        }
        return this.setNewToLike(0, this.buildTo(0));
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> editLastTo() {
        int index = this.to.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last to. The list is empty.");
        }
        return this.setNewToLike(index, this.buildTo(index));
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> editMatchingTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.to.size(); ++i) {
            if (!predicate.apply(this.to.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching to. No match found.");
        }
        return this.setNewToLike(index, this.buildTo(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkPolicyEgressRuleFluentImpl that = (NetworkPolicyEgressRuleFluentImpl)o;
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        return !(this.to != null ? !this.to.equals(that.to) : that.to != null);
    }

    public int hashCode() {
        return Objects.hash(this.ports, this.to, super.hashCode());
    }

    public class ToNestedImpl<N>
    extends NetworkPolicyPeerFluentImpl<NetworkPolicyEgressRuleFluent.ToNested<N>>
    implements NetworkPolicyEgressRuleFluent.ToNested<N>,
    Nested<N> {
        private final NetworkPolicyPeerBuilder builder;
        private final int index;

        ToNestedImpl(int index, NetworkPolicyPeer item) {
            this.index = index;
            this.builder = new NetworkPolicyPeerBuilder(this, item);
        }

        ToNestedImpl() {
            this.index = -1;
            this.builder = new NetworkPolicyPeerBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyEgressRuleFluentImpl.this.setToTo(this.index, this.builder.build());
        }

        @Override
        public N endTo() {
            return this.and();
        }
    }

    public class PortsNestedImpl<N>
    extends NetworkPolicyPortFluentImpl<NetworkPolicyEgressRuleFluent.PortsNested<N>>
    implements NetworkPolicyEgressRuleFluent.PortsNested<N>,
    Nested<N> {
        private final NetworkPolicyPortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, NetworkPolicyPort item) {
            this.index = index;
            this.builder = new NetworkPolicyPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new NetworkPolicyPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyEgressRuleFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

