/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_12.handlers;

import io.fabric8.kubernetes.api.model.v4_12.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_12.ListOptions;
import io.fabric8.kubernetes.clnt.v4_12.Config;
import io.fabric8.kubernetes.clnt.v4_12.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_12.Watch;
import io.fabric8.kubernetes.clnt.v4_12.Watcher;
import io.fabric8.kubernetes.clnt.v4_12.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_12.dsl.Resource;
import io.fabric8.openshift.api.model.v4_12.Proxy;
import io.fabric8.openshift.api.model.v4_12.ProxyBuilder;
import io.fabric8.openshift.clnt.v4_12.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.ProxyOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ProxyHandler
implements ResourceHandler<Proxy, ProxyBuilder> {
    @Override
    public String getKind() {
        return Proxy.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    @Override
    public Proxy create(OkHttpClient client, Config config, String namespace, Proxy item) {
        return (Proxy)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Proxy[0]);
    }

    @Override
    public Proxy replace(OkHttpClient client, Config config, String namespace, Proxy item) {
        return (Proxy)((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Proxy reload(OkHttpClient client, Config config, String namespace, Proxy item) {
        return (Proxy)((Gettable)((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ProxyBuilder edit(Proxy item) {
        return new ProxyBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Proxy item) {
        return (Boolean)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Proxy item, Watcher<Proxy> watcher) {
        return (Watch)((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Proxy item, String resourceVersion, Watcher<Proxy> watcher) {
        return (Watch)((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Proxy item, ListOptions options, Watcher<Proxy> watcher) {
        return (Watch)((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Proxy waitUntilReady(OkHttpClient client, Config config, String namespace, Proxy item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Proxy)((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Proxy waitUntilCondition(OkHttpClient client, Config config, String namespace, Proxy item, Predicate<Proxy> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Proxy)((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

