/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_12.handlers;

import io.fabric8.kubernetes.api.model.v4_12.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_12.ListOptions;
import io.fabric8.kubernetes.clnt.v4_12.Config;
import io.fabric8.kubernetes.clnt.v4_12.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_12.Watch;
import io.fabric8.kubernetes.clnt.v4_12.Watcher;
import io.fabric8.kubernetes.clnt.v4_12.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_12.dsl.Resource;
import io.fabric8.openshift.api.model.v4_12.OAuthAccessToken;
import io.fabric8.openshift.api.model.v4_12.OAuthAccessTokenBuilder;
import io.fabric8.openshift.clnt.v4_12.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.OAuthAccessTokenOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class OAuthAccessTokenHandler
implements ResourceHandler<OAuthAccessToken, OAuthAccessTokenBuilder> {
    @Override
    public String getKind() {
        return OAuthAccessToken.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "oauth.openshift.io/v1";
    }

    @Override
    public OAuthAccessToken create(OkHttpClient client, Config config, String namespace, OAuthAccessToken item) {
        return (OAuthAccessToken)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new OAuthAccessToken[0]);
    }

    @Override
    public OAuthAccessToken replace(OkHttpClient client, Config config, String namespace, OAuthAccessToken item) {
        return (OAuthAccessToken)((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public OAuthAccessToken reload(OkHttpClient client, Config config, String namespace, OAuthAccessToken item) {
        return (OAuthAccessToken)((Gettable)((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public OAuthAccessTokenBuilder edit(OAuthAccessToken item) {
        return new OAuthAccessTokenBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, OAuthAccessToken item) {
        return (Boolean)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, Watcher<OAuthAccessToken> watcher) {
        return (Watch)((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, String resourceVersion, Watcher<OAuthAccessToken> watcher) {
        return (Watch)((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, ListOptions options, Watcher<OAuthAccessToken> watcher) {
        return (Watch)((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public OAuthAccessToken waitUntilReady(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuthAccessToken)((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public OAuthAccessToken waitUntilCondition(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, Predicate<OAuthAccessToken> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuthAccessToken)((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

