/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_12.handlers;

import io.fabric8.kubernetes.api.model.v4_12.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_12.ListOptions;
import io.fabric8.kubernetes.clnt.v4_12.Config;
import io.fabric8.kubernetes.clnt.v4_12.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_12.Watch;
import io.fabric8.kubernetes.clnt.v4_12.Watcher;
import io.fabric8.kubernetes.clnt.v4_12.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_12.dsl.Resource;
import io.fabric8.openshift.api.model.v4_12.operator.v1.DNS;
import io.fabric8.openshift.api.model.v4_12.operator.v1.DNSBuilder;
import io.fabric8.openshift.clnt.v4_12.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.DNSOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class DNSHandler
implements ResourceHandler<DNS, DNSBuilder> {
    @Override
    public String getKind() {
        return DNS.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "operator.openshift.io/v1";
    }

    @Override
    public DNS create(OkHttpClient client, Config config, String namespace, DNS item) {
        return (DNS)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new DNS[0]);
    }

    @Override
    public DNS replace(OkHttpClient client, Config config, String namespace, DNS item) {
        return (DNS)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public DNS reload(OkHttpClient client, Config config, String namespace, DNS item) {
        return (DNS)((Gettable)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public DNSBuilder edit(DNS item) {
        return new DNSBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, DNS item) {
        return (Boolean)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, DNS item, Watcher<DNS> watcher) {
        return (Watch)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, DNS item, String resourceVersion, Watcher<DNS> watcher) {
        return (Watch)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, DNS item, ListOptions options, Watcher<DNS> watcher) {
        return (Watch)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public DNS waitUntilReady(OkHttpClient client, Config config, String namespace, DNS item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (DNS)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public DNS waitUntilCondition(OkHttpClient client, Config config, String namespace, DNS item, Predicate<DNS> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (DNS)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

