/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_12;

import io.fabric8.kubernetes.api.model.v4_12.APIService;
import io.fabric8.kubernetes.api.model.v4_12.APIServiceList;
import io.fabric8.kubernetes.api.model.v4_12.Binding;
import io.fabric8.kubernetes.api.model.v4_12.ComponentStatus;
import io.fabric8.kubernetes.api.model.v4_12.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v4_12.ConfigMap;
import io.fabric8.kubernetes.api.model.v4_12.ConfigMapList;
import io.fabric8.kubernetes.api.model.v4_12.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_12.Doneable;
import io.fabric8.kubernetes.api.model.v4_12.DoneableAPIService;
import io.fabric8.kubernetes.api.model.v4_12.DoneableBinding;
import io.fabric8.kubernetes.api.model.v4_12.DoneableComponentStatus;
import io.fabric8.kubernetes.api.model.v4_12.DoneableConfigMap;
import io.fabric8.kubernetes.api.model.v4_12.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.v4_12.DoneableEvent;
import io.fabric8.kubernetes.api.model.v4_12.DoneableLimitRange;
import io.fabric8.kubernetes.api.model.v4_12.DoneableNamespace;
import io.fabric8.kubernetes.api.model.v4_12.DoneableNode;
import io.fabric8.kubernetes.api.model.v4_12.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.v4_12.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v4_12.DoneablePod;
import io.fabric8.kubernetes.api.model.v4_12.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.v4_12.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.v4_12.DoneableSecret;
import io.fabric8.kubernetes.api.model.v4_12.DoneableService;
import io.fabric8.kubernetes.api.model.v4_12.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.v4_12.Endpoints;
import io.fabric8.kubernetes.api.model.v4_12.EndpointsList;
import io.fabric8.kubernetes.api.model.v4_12.Event;
import io.fabric8.kubernetes.api.model.v4_12.EventList;
import io.fabric8.kubernetes.api.model.v4_12.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_12.KubernetesList;
import io.fabric8.kubernetes.api.model.v4_12.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.v4_12.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v4_12.LimitRange;
import io.fabric8.kubernetes.api.model.v4_12.LimitRangeList;
import io.fabric8.kubernetes.api.model.v4_12.Namespace;
import io.fabric8.kubernetes.api.model.v4_12.NamespaceList;
import io.fabric8.kubernetes.api.model.v4_12.Node;
import io.fabric8.kubernetes.api.model.v4_12.NodeList;
import io.fabric8.kubernetes.api.model.v4_12.PersistentVolume;
import io.fabric8.kubernetes.api.model.v4_12.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v4_12.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v4_12.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v4_12.Pod;
import io.fabric8.kubernetes.api.model.v4_12.PodList;
import io.fabric8.kubernetes.api.model.v4_12.ReplicationController;
import io.fabric8.kubernetes.api.model.v4_12.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v4_12.ResourceQuota;
import io.fabric8.kubernetes.api.model.v4_12.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v4_12.RootPaths;
import io.fabric8.kubernetes.api.model.v4_12.Secret;
import io.fabric8.kubernetes.api.model.v4_12.SecretList;
import io.fabric8.kubernetes.api.model.v4_12.Service;
import io.fabric8.kubernetes.api.model.v4_12.ServiceAccount;
import io.fabric8.kubernetes.api.model.v4_12.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v4_12.ServiceList;
import io.fabric8.kubernetes.api.model.v4_12.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.v4_12.apiextensions.v1beta1.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.v4_12.apiextensions.v1beta1.DoneableCustomResourceDefinition;
import io.fabric8.kubernetes.api.model.v4_12.authentication.DoneableTokenReview;
import io.fabric8.kubernetes.api.model.v4_12.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.v4_12.certificates.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.v4_12.certificates.CertificateSigningRequestList;
import io.fabric8.kubernetes.api.model.v4_12.certificates.DoneableCertificateSigningRequest;
import io.fabric8.kubernetes.api.model.v4_12.coordination.v1.DoneableLease;
import io.fabric8.kubernetes.api.model.v4_12.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.v4_12.coordination.v1.LeaseList;
import io.fabric8.kubernetes.clnt.v4_12.AdmissionRegistrationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_12.AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.AppsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_12.AutoscalingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_12.BaseClient;
import io.fabric8.kubernetes.clnt.v4_12.BatchAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_12.Config;
import io.fabric8.kubernetes.clnt.v4_12.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_12.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_12.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_12.MetricAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_12.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_12.NetworkAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_12.PolicyAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_12.RbacAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_12.RequestConfig;
import io.fabric8.kubernetes.clnt.v4_12.SchedulingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_12.SettingsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_12.StorageAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_12.V1APIGroupClient;
import io.fabric8.kubernetes.clnt.v4_12.VersionInfo;
import io.fabric8.kubernetes.clnt.v4_12.WithRequestCallable;
import io.fabric8.kubernetes.clnt.v4_12.dsl.ApiextensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.dsl.AuthorizationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.dsl.BatchAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.dsl.Createable;
import io.fabric8.kubernetes.clnt.v4_12.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v4_12.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v4_12.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v4_12.dsl.MetricAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v4_12.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_12.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_12.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_12.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.clnt.v4_12.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_12.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v4_12.dsl.PolicyAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.dsl.RbacAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_12.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_12.dsl.SchedulingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v4_12.dsl.SettingsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.dsl.StorageAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.dsl.V1APIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_12.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v4_12.dsl.internal.CustomResourceOperationContext;
import io.fabric8.kubernetes.clnt.v4_12.dsl.internal.CustomResourceOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_12.dsl.internal.RawCustomResourceOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_12.dsl.internal.apiextensions.v1beta1.CustomResourceDefinitionOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_12.dsl.internal.coordination.v1.LeaseOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_12.dsl.internal.core.v1.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_12.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.clnt.v4_12.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.clnt.v4_12.extended.run.RunOperations;
import io.fabric8.kubernetes.clnt.v4_12.informers.SharedInformerFactory;
import io.fabric8.kubernetes.clnt.v4_12.utils.BackwardsCompatibilityInterceptor;
import io.fabric8.kubernetes.clnt.v4_12.utils.ImpersonatorInterceptor;
import io.fabric8.kubernetes.clnt.v4_12.utils.Serialization;
import io.fabric8.kubernetes.clnt.v4_12.utils.Utils;
import io.fabric8.openshift.api.model.v4_12.Build;
import io.fabric8.openshift.api.model.v4_12.BuildConfig;
import io.fabric8.openshift.api.model.v4_12.BuildConfigList;
import io.fabric8.openshift.api.model.v4_12.BuildList;
import io.fabric8.openshift.api.model.v4_12.ClusterNetwork;
import io.fabric8.openshift.api.model.v4_12.ClusterNetworkList;
import io.fabric8.openshift.api.model.v4_12.ClusterRoleBinding;
import io.fabric8.openshift.api.model.v4_12.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.v4_12.DeploymentConfig;
import io.fabric8.openshift.api.model.v4_12.DeploymentConfigList;
import io.fabric8.openshift.api.model.v4_12.DoneableBuild;
import io.fabric8.openshift.api.model.v4_12.DoneableBuildConfig;
import io.fabric8.openshift.api.model.v4_12.DoneableClusterNetwork;
import io.fabric8.openshift.api.model.v4_12.DoneableClusterRoleBinding;
import io.fabric8.openshift.api.model.v4_12.DoneableDeploymentConfig;
import io.fabric8.openshift.api.model.v4_12.DoneableEgressNetworkPolicy;
import io.fabric8.openshift.api.model.v4_12.DoneableGroup;
import io.fabric8.openshift.api.model.v4_12.DoneableImage;
import io.fabric8.openshift.api.model.v4_12.DoneableImageStream;
import io.fabric8.openshift.api.model.v4_12.DoneableImageStreamTag;
import io.fabric8.openshift.api.model.v4_12.DoneableImageTag;
import io.fabric8.openshift.api.model.v4_12.DoneableNetNamespace;
import io.fabric8.openshift.api.model.v4_12.DoneableOAuthAccessToken;
import io.fabric8.openshift.api.model.v4_12.DoneableOAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v4_12.DoneableOAuthClient;
import io.fabric8.openshift.api.model.v4_12.DoneableRangeAllocation;
import io.fabric8.openshift.api.model.v4_12.DoneableRole;
import io.fabric8.openshift.api.model.v4_12.DoneableRoleBinding;
import io.fabric8.openshift.api.model.v4_12.DoneableRoute;
import io.fabric8.openshift.api.model.v4_12.DoneableSecurityContextConstraints;
import io.fabric8.openshift.api.model.v4_12.DoneableSubjectAccessReview;
import io.fabric8.openshift.api.model.v4_12.DoneableTemplate;
import io.fabric8.openshift.api.model.v4_12.DoneableUser;
import io.fabric8.openshift.api.model.v4_12.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.v4_12.EgressNetworkPolicyList;
import io.fabric8.openshift.api.model.v4_12.Group;
import io.fabric8.openshift.api.model.v4_12.GroupList;
import io.fabric8.openshift.api.model.v4_12.Image;
import io.fabric8.openshift.api.model.v4_12.ImageList;
import io.fabric8.openshift.api.model.v4_12.ImageStream;
import io.fabric8.openshift.api.model.v4_12.ImageStreamList;
import io.fabric8.openshift.api.model.v4_12.ImageStreamTag;
import io.fabric8.openshift.api.model.v4_12.ImageStreamTagList;
import io.fabric8.openshift.api.model.v4_12.ImageTag;
import io.fabric8.openshift.api.model.v4_12.ImageTagList;
import io.fabric8.openshift.api.model.v4_12.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.v4_12.NetNamespace;
import io.fabric8.openshift.api.model.v4_12.NetNamespaceList;
import io.fabric8.openshift.api.model.v4_12.OAuthAccessToken;
import io.fabric8.openshift.api.model.v4_12.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.v4_12.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v4_12.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.v4_12.OAuthClient;
import io.fabric8.openshift.api.model.v4_12.OAuthClientList;
import io.fabric8.openshift.api.model.v4_12.RangeAllocation;
import io.fabric8.openshift.api.model.v4_12.RangeAllocationList;
import io.fabric8.openshift.api.model.v4_12.Role;
import io.fabric8.openshift.api.model.v4_12.RoleBinding;
import io.fabric8.openshift.api.model.v4_12.RoleBindingList;
import io.fabric8.openshift.api.model.v4_12.RoleList;
import io.fabric8.openshift.api.model.v4_12.Route;
import io.fabric8.openshift.api.model.v4_12.RouteList;
import io.fabric8.openshift.api.model.v4_12.SecurityContextConstraints;
import io.fabric8.openshift.api.model.v4_12.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.v4_12.SubjectAccessReview;
import io.fabric8.openshift.api.model.v4_12.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.v4_12.Template;
import io.fabric8.openshift.api.model.v4_12.TemplateList;
import io.fabric8.openshift.api.model.v4_12.User;
import io.fabric8.openshift.api.model.v4_12.UserList;
import io.fabric8.openshift.clnt.v4_12.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v4_12.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_12.OpenShiftConfigAPIGroupClient;
import io.fabric8.openshift.clnt.v4_12.OpenShiftConfigBuilder;
import io.fabric8.openshift.clnt.v4_12.OpenShiftConsoleAPIGroupClient;
import io.fabric8.openshift.clnt.v4_12.OpenShiftLocalSubjectAccessReviewOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.OpenShiftMonitoringAPIGroupClient;
import io.fabric8.openshift.clnt.v4_12.OpenShiftOperatorAPIGroupClient;
import io.fabric8.openshift.clnt.v4_12.OpenShiftOperatorHubAPIGroupClient;
import io.fabric8.openshift.clnt.v4_12.OpenShiftQuotaAPIGroupClient;
import io.fabric8.openshift.clnt.v4_12.OpenshiftAdapterSupport;
import io.fabric8.openshift.clnt.v4_12.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v4_12.dsl.BuildResource;
import io.fabric8.openshift.clnt.v4_12.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v4_12.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.clnt.v4_12.dsl.OpenShiftConsoleAPIGroupDSL;
import io.fabric8.openshift.clnt.v4_12.dsl.OpenShiftMonitoringAPIGroupDSL;
import io.fabric8.openshift.clnt.v4_12.dsl.OpenShiftOperatorAPIGroupDSL;
import io.fabric8.openshift.clnt.v4_12.dsl.OpenShiftOperatorHubAPIGroupDSL;
import io.fabric8.openshift.clnt.v4_12.dsl.OpenShiftQuotaAPIGroupDSL;
import io.fabric8.openshift.clnt.v4_12.dsl.ProjectOperation;
import io.fabric8.openshift.clnt.v4_12.dsl.ProjectRequestOperation;
import io.fabric8.openshift.clnt.v4_12.dsl.TemplateResource;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.BuildConfigOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.BuildOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.ClusterNetworkOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.ClusterRoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.EgressNetworkPolicyOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.GroupOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.ImageOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.ImageStreamOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.ImageStreamTagOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.ImageTagOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.NetNamespaceOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.OAuthClientOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.OpenShiftSubjectAccessReviewOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.ProjectOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.ProjectRequestsOperationImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.RangeAllocationOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.RoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.RoleOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.RouteOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.SecurityContextConstraintsOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.TemplateOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.dsl.internal.UserOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.internal.OpenShiftClusterOperationsImpl;
import io.fabric8.openshift.clnt.v4_12.internal.OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import io.fabric8.openshift.clnt.v4_12.internal.OpenShiftOAuthInterceptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class DefaultOpenShiftClient
extends BaseClient
implements NamespacedOpenShiftClient {
    private static final String API_GROUPS_ENABLED = "API_GROUPS_ENABLED";
    private static final Map<String, Boolean> API_GROUPS_ENABLED_PER_URL = new HashMap<String, Boolean>();
    private URL openShiftUrl;
    private NamespacedKubernetesClient delegate;

    public DefaultOpenShiftClient() throws KubernetesClientException {
        this(new OpenShiftConfigBuilder().build());
    }

    public DefaultOpenShiftClient(String masterUrl) throws KubernetesClientException {
        this(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public DefaultOpenShiftClient(Config config) throws KubernetesClientException {
        this(new OpenShiftConfig(config));
    }

    public DefaultOpenShiftClient(OpenShiftConfig config) throws KubernetesClientException {
        super(DefaultOpenShiftClient.configWithApiGroupsEnabled(DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(config), config));
        try {
            this.httpClient = DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(this.httpClient, config);
            this.delegate = new DefaultKubernetesClient(this.httpClient, config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    public DefaultOpenShiftClient(OkHttpClient httpClient, OpenShiftConfig config) throws KubernetesClientException {
        super(httpClient, DefaultOpenShiftClient.configWithApiGroupsEnabled(httpClient, config));
        try {
            this.httpClient = DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(httpClient, this.getConfiguration());
            this.delegate = new DefaultKubernetesClient(this.httpClient, config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    private static OpenShiftConfig configWithApiGroupsEnabled(OkHttpClient httpClient, OpenShiftConfig config) {
        String url = config.getMasterUrl();
        Boolean openshiftApiGroupsEnabled = API_GROUPS_ENABLED_PER_URL.containsKey(url);
        if (openshiftApiGroupsEnabled.booleanValue()) {
            return config;
        }
        if (!config.isDisableApiGroupCheck()) {
            return config.withOpenshiftApiGroupsEnabled(false);
        }
        Boolean enabled = OpenshiftAdapterSupport.isOpenShiftAPIGroups(httpClient, url);
        API_GROUPS_ENABLED_PER_URL.put(url, enabled);
        return config.withOpenshiftApiGroupsEnabled(enabled);
    }

    public static DefaultOpenShiftClient fromConfig(String config) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(config, OpenShiftConfig.class));
    }

    public static DefaultOpenShiftClient fromConfig(InputStream is) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(is, OpenShiftConfig.class));
    }

    private static OkHttpClient clientWithOpenShiftOAuthInterceptor(Config config) {
        return DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(null, config);
    }

    private static OkHttpClient clientWithOpenShiftOAuthInterceptor(OkHttpClient httpClient, Config config) {
        OkHttpClient.Builder builder = httpClient != null ? httpClient.newBuilder().authenticator(Authenticator.NONE) : new OkHttpClient.Builder().authenticator(Authenticator.NONE);
        builder.interceptors().clear();
        return builder.addInterceptor((Interceptor)new OpenShiftOAuthInterceptor(httpClient, OpenShiftConfig.wrap(config))).addInterceptor((Interceptor)new ImpersonatorInterceptor(config)).addInterceptor((Interceptor)new BackwardsCompatibilityInterceptor()).build();
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.openShiftUrl;
    }

    @Override
    public OpenShiftConfigAPIGroupDSL config() {
        return this.adapt(OpenShiftConfigAPIGroupClient.class);
    }

    @Override
    public OpenShiftConsoleAPIGroupDSL console() {
        return this.adapt(OpenShiftConsoleAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorAPIGroupDSL operator() {
        return this.adapt(OpenShiftOperatorAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorHubAPIGroupDSL operatorHub() {
        return this.adapt(OpenShiftOperatorHubAPIGroupClient.class);
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), is, null, true, DeletionPropagation.BACKGROUND){};
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata item) {
        return this.delegate.resource(item);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList item) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), item, null, DeletionPropagation.BACKGROUND, true){};
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(HasMetadata ... items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(items)).build());
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), s, null, DeletionPropagation.BACKGROUND, true){};
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Binding, KubernetesResourceList<Binding>, DoneableBinding, Resource<Binding, DoneableBinding>> bindings() {
        return this.delegate.bindings();
    }

    @Override
    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<Service, ServiceList, DoneableService, ServiceResource<Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public MixedOperation<APIService, APIServiceList, DoneableAPIService, Resource<APIService, DoneableAPIService>> apiServices() {
        return this.delegate.apiServices();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResources(CustomResourceDefinitionContext crdContext, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return new CustomResourceOperationsImpl(new CustomResourceOperationContext().withOkhttpClient(this.httpClient).withConfig(this.getConfiguration()).withCrdContext(crdContext).withType(resourceType).withListType(listClass).withDoneableType(doneClass));
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResources(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return new CustomResourceOperationsImpl(new CustomResourceOperationContext().withOkhttpClient(this.httpClient).withConfig(this.getConfiguration()).withCrd(crd).withType(resourceType).withListType(listClass).withDoneableType(doneClass));
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResource(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return this.customResources(crd, resourceType, listClass, doneClass);
    }

    @Override
    public NonNamespaceOperation<CustomResourceDefinition, CustomResourceDefinitionList, DoneableCustomResourceDefinition, Resource<CustomResourceDefinition, DoneableCustomResourceDefinition>> customResourceDefinitions() {
        return new CustomResourceDefinitionOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ApiextensionsAPIGroupDSL apiextensions() {
        return this.delegate.apiextensions();
    }

    @Override
    public NonNamespaceOperation<CertificateSigningRequest, CertificateSigningRequestList, DoneableCertificateSigningRequest, Resource<CertificateSigningRequest, DoneableCertificateSigningRequest>> certificateSigningRequests() {
        return this.delegate.certificateSigningRequests();
    }

    @Override
    public AuthorizationAPIGroupDSL authorization() {
        return this.delegate.authorization();
    }

    @Override
    public Createable<TokenReview, TokenReview, DoneableTokenReview> tokenReviews() {
        return this.delegate.tokenReviews();
    }

    @Override
    public RawCustomResourceOperationsImpl customResource(CustomResourceDefinitionContext customResourceDefinition) {
        return new RawCustomResourceOperationsImpl(this.httpClient, this.getConfiguration(), customResourceDefinition);
    }

    @Override
    public MixedOperation<Build, BuildList, DoneableBuild, BuildResource<Build, DoneableBuild, String, LogWatch>> builds() {
        return new BuildOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>> buildConfigs() {
        return new BuildConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig>> deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    public MixedOperation<Group, GroupList, DoneableGroup, Resource<Group, DoneableGroup>> groups() {
        return new GroupOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Image, ImageList, DoneableImage, Resource<Image, DoneableImage>> images() {
        return new ImageOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<ImageTag, ImageTagList, DoneableImageTag, Resource<ImageTag, DoneableImageTag>> imageTags() {
        return new ImageTagOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, DoneableImageStream, Resource<ImageStream, DoneableImageStream>> imageStreams() {
        return new ImageStreamOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, DoneableImageStreamTag, Resource<ImageStreamTag, DoneableImageStreamTag>> imageStreamTags() {
        return new ImageStreamTagOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, DoneableOAuthAccessToken, Resource<OAuthAccessToken, DoneableOAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, DoneableOAuthAuthorizeToken, Resource<OAuthAuthorizeToken, DoneableOAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, DoneableOAuthClient, Resource<OAuthClient, DoneableOAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public ProjectOperation projects() {
        return new ProjectOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public OpenShiftQuotaAPIGroupDSL quotas() {
        return this.adapt(OpenShiftQuotaAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<RangeAllocation, RangeAllocationList, DoneableRangeAllocation, Resource<RangeAllocation, DoneableRangeAllocation>> rangeAllocations() {
        return new RangeAllocationOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, Resource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return new SecurityContextConstraintsOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return new ProjectRequestsOperationImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<Role, RoleList, DoneableRole, Resource<Role, DoneableRole>> roles() {
        return new RoleOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<RoleBinding, RoleBindingList, DoneableRoleBinding, Resource<RoleBinding, DoneableRoleBinding>> roleBindings() {
        return new RoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<Route, RouteList, DoneableRoute, Resource<Route, DoneableRoute>> routes() {
        return new RouteOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public ParameterMixedOperation<Template, TemplateList, DoneableTemplate, TemplateResource<Template, KubernetesList, DoneableTemplate>> templates() {
        return new TemplateOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    public MixedOperation<User, UserList, DoneableUser, Resource<User, DoneableUser>> users() {
        return new UserOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, DoneableClusterRoleBinding, Resource<ClusterRoleBinding, DoneableClusterRoleBinding>> clusterRoleBindings() {
        return new ClusterRoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NamespacedOpenShiftClient inNamespace(String namespace) {
        OpenShiftConfig updated = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(new OpenShiftConfig(this.getConfiguration())).withOpenShiftUrl(this.openShiftUrl.toString())).withNamespace(namespace)).build();
        return new DefaultOpenShiftClient(this.httpClient, updated);
    }

    @Override
    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupClient extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        return new OpenShiftClusterOperationsImpl(this.httpClient, this.getConfiguration(), "version/openshift").fetchVersion();
    }

    @Override
    public V1APIGroupDSL v1() {
        return this.adapt(V1APIGroupClient.class);
    }

    @Override
    public RunOperations run() {
        return new RunOperations(this.httpClient, this.getConfiguration(), this.getNamespace(), new RunConfigBuilder());
    }

    @Override
    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.adapt(AdmissionRegistrationAPIGroupClient.class);
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.adapt(AppsAPIGroupClient.class);
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.adapt(AutoscalingAPIGroupClient.class);
    }

    @Override
    public OpenShiftMonitoringAPIGroupDSL monitoring() {
        return this.adapt(OpenShiftMonitoringAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<NetNamespace, NetNamespaceList, DoneableNetNamespace, Resource<NetNamespace, DoneableNetNamespace>> netNamespaces() {
        return new NetNamespaceOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<ClusterNetwork, ClusterNetworkList, DoneableClusterNetwork, Resource<ClusterNetwork, DoneableClusterNetwork>> clusterNetworks() {
        return new ClusterNetworkOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<EgressNetworkPolicy, EgressNetworkPolicyList, DoneableEgressNetworkPolicy, Resource<EgressNetworkPolicy, DoneableEgressNetworkPolicy>> egressNetworkPolicies() {
        return new EgressNetworkPolicyOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.adapt(NetworkAPIGroupClient.class);
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.adapt(StorageAPIGroupClient.class);
    }

    @Override
    public SettingsAPIGroupDSL settings() {
        return this.adapt(SettingsAPIGroupClient.class);
    }

    @Override
    public Createable<SubjectAccessReview, SubjectAccessReviewResponse, DoneableSubjectAccessReview> subjectAccessReviews() {
        return new OpenShiftSubjectAccessReviewOperationsImpl(this.httpClient, this.getConfiguration(), "authorization.openshift.io", "v1", Utils.getPluralFromKind(SubjectAccessReview.class.getSimpleName()));
    }

    @Override
    public OpenShiftLocalSubjectAccessReviewOperationsImpl localSubjectAccessReviews() {
        return new OpenShiftLocalSubjectAccessReviewOperationsImpl(this.httpClient, this.getConfiguration(), "authorization.openshift.io", "v1", Utils.getPluralFromKind(LocalSubjectAccessReview.class.getSimpleName()));
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.adapt(BatchAPIGroupClient.class);
    }

    @Override
    public MetricAPIGroupDSL top() {
        return this.adapt(MetricAPIGroupClient.class);
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.adapt(PolicyAPIGroupClient.class);
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.adapt(RbacAPIGroupClient.class);
    }

    @Override
    public SchedulingAPIGroupDSL scheduling() {
        return this.adapt(SchedulingAPIGroupClient.class);
    }

    @Override
    public SharedInformerFactory informers() {
        return new SharedInformerFactory(ForkJoinPool.commonPool(), this.httpClient, this.getConfiguration());
    }

    @Override
    public SharedInformerFactory informers(ExecutorService executorService) {
        return new SharedInformerFactory(executorService, this.httpClient, this.getConfiguration());
    }

    public LeaderElectorBuilder<NamespacedOpenShiftClient> leaderElector() {
        return new LeaderElectorBuilder<NamespacedOpenShiftClient>(this);
    }

    @Override
    public MixedOperation<Lease, LeaseList, DoneableLease, Resource<Lease, DoneableLease>> leases() {
        return new LeaseOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedOpenShiftClient>(this, requestConfig);
    }

    @Override
    public User currentUser() {
        return (User)((Resource)this.users().withName("~")).get();
    }

    @Override
    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        List<String> paths;
        String apiGroupPath = "/apis/" + apiGroup;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path) && !Objects.equals(apiGroupPath, path)) continue;
                return true;
            }
        }
        return false;
    }
}

