/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_12.operator.v1;

import io.fabric8.kubernetes.api.builder.v4_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_12.Predicate;
import io.fabric8.openshift.api.model.v4_12.operator.v1.ForwardPlugin;
import io.fabric8.openshift.api.model.v4_12.operator.v1.ForwardPluginFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ForwardPluginFluentImpl<A extends ForwardPluginFluent<A>>
extends BaseFluent<A>
implements ForwardPluginFluent<A> {
    private List<String> upstreams = new ArrayList<String>();

    public ForwardPluginFluentImpl() {
    }

    public ForwardPluginFluentImpl(ForwardPlugin instance) {
        this.withUpstreams(instance.getUpstreams());
    }

    @Override
    public A addToUpstreams(int index, String item) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList<String>();
        }
        this.upstreams.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUpstreams(int index, String item) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList<String>();
        }
        this.upstreams.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUpstreams(String ... items) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList<String>();
        }
        for (String item : items) {
            this.upstreams.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUpstreams(Collection<String> items) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList<String>();
        }
        for (String item : items) {
            this.upstreams.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUpstreams(String ... items) {
        for (String item : items) {
            if (this.upstreams == null) continue;
            this.upstreams.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUpstreams(Collection<String> items) {
        for (String item : items) {
            if (this.upstreams == null) continue;
            this.upstreams.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUpstreams() {
        return this.upstreams;
    }

    @Override
    public String getUpstream(int index) {
        return this.upstreams.get(index);
    }

    @Override
    public String getFirstUpstream() {
        return this.upstreams.get(0);
    }

    @Override
    public String getLastUpstream() {
        return this.upstreams.get(this.upstreams.size() - 1);
    }

    @Override
    public String getMatchingUpstream(Predicate<String> predicate) {
        for (String item : this.upstreams) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUpstream(Predicate<String> predicate) {
        for (String item : this.upstreams) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUpstreams(List<String> upstreams) {
        if (this.upstreams != null) {
            this._visitables.get("upstreams").removeAll(this.upstreams);
        }
        if (upstreams != null) {
            this.upstreams = new ArrayList<String>();
            for (String item : upstreams) {
                this.addToUpstreams(item);
            }
        } else {
            this.upstreams = null;
        }
        return (A)this;
    }

    @Override
    public A withUpstreams(String ... upstreams) {
        if (this.upstreams != null) {
            this.upstreams.clear();
        }
        if (upstreams != null) {
            for (String item : upstreams) {
                this.addToUpstreams(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUpstreams() {
        return this.upstreams != null && !this.upstreams.isEmpty();
    }

    @Override
    public A addNewUpstream(String arg1) {
        return this.addToUpstreams(new String(arg1));
    }

    @Override
    public A addNewUpstream(StringBuilder arg1) {
        return this.addToUpstreams(new String(arg1));
    }

    @Override
    public A addNewUpstream(StringBuffer arg1) {
        return this.addToUpstreams(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForwardPluginFluentImpl that = (ForwardPluginFluentImpl)o;
        return !(this.upstreams != null ? !this.upstreams.equals(that.upstreams) : that.upstreams != null);
    }

    public int hashCode() {
        return Objects.hash(this.upstreams, super.hashCode());
    }
}

