/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_12;

import io.fabric8.kubernetes.api.builder.v4_12.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_12.DeploymentConfig;
import io.fabric8.openshift.api.model.v4_12.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.v4_12.DeploymentConfigFluentImpl;
import java.util.Objects;

public class DeploymentConfigBuilder
extends DeploymentConfigFluentImpl<DeploymentConfigBuilder>
implements VisitableBuilder<DeploymentConfig, DeploymentConfigBuilder> {
    DeploymentConfigFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentConfigBuilder() {
        this(true);
    }

    public DeploymentConfigBuilder(Boolean validationEnabled) {
        this(new DeploymentConfig(), validationEnabled);
    }

    public DeploymentConfigBuilder(DeploymentConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentConfigBuilder(DeploymentConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentConfig(), validationEnabled);
    }

    public DeploymentConfigBuilder(DeploymentConfigFluent<?> fluent, DeploymentConfig instance) {
        this(fluent, instance, true);
    }

    public DeploymentConfigBuilder(DeploymentConfigFluent<?> fluent, DeploymentConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentConfigBuilder(DeploymentConfig instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentConfigBuilder(DeploymentConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public DeploymentConfig build() {
        DeploymentConfig buildable = new DeploymentConfig(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigBuilder that = (DeploymentConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

