/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_12;

import io.fabric8.kubernetes.api.builder.v4_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_12.Nested;
import io.fabric8.kubernetes.api.model.v4_12.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_12.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v4_12.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v4_12.ClusterOperator;
import io.fabric8.openshift.api.model.v4_12.ClusterOperatorFluent;
import io.fabric8.openshift.api.model.v4_12.ClusterOperatorSpec;
import io.fabric8.openshift.api.model.v4_12.ClusterOperatorSpecBuilder;
import io.fabric8.openshift.api.model.v4_12.ClusterOperatorSpecFluentImpl;
import io.fabric8.openshift.api.model.v4_12.ClusterOperatorStatus;
import io.fabric8.openshift.api.model.v4_12.ClusterOperatorStatusBuilder;
import io.fabric8.openshift.api.model.v4_12.ClusterOperatorStatusFluentImpl;
import java.util.Objects;

public class ClusterOperatorFluentImpl<A extends ClusterOperatorFluent<A>>
extends BaseFluent<A>
implements ClusterOperatorFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ClusterOperatorSpecBuilder spec;
    private ClusterOperatorStatusBuilder status;

    public ClusterOperatorFluentImpl() {
    }

    public ClusterOperatorFluentImpl(ClusterOperator instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ClusterOperatorFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterOperatorFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterOperatorFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ClusterOperatorFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ClusterOperatorFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ClusterOperatorSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ClusterOperatorSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ClusterOperatorSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ClusterOperatorSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ClusterOperatorFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ClusterOperatorFluent.SpecNested<A> withNewSpecLike(ClusterOperatorSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ClusterOperatorFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ClusterOperatorFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ClusterOperatorSpecBuilder().build());
    }

    @Override
    public ClusterOperatorFluent.SpecNested<A> editOrNewSpecLike(ClusterOperatorSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ClusterOperatorStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ClusterOperatorStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ClusterOperatorStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new ClusterOperatorStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ClusterOperatorFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ClusterOperatorFluent.StatusNested<A> withNewStatusLike(ClusterOperatorStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ClusterOperatorFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ClusterOperatorFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ClusterOperatorStatusBuilder().build());
    }

    @Override
    public ClusterOperatorFluent.StatusNested<A> editOrNewStatusLike(ClusterOperatorStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterOperatorFluentImpl that = (ClusterOperatorFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends ClusterOperatorStatusFluentImpl<ClusterOperatorFluent.StatusNested<N>>
    implements ClusterOperatorFluent.StatusNested<N>,
    Nested<N> {
        private final ClusterOperatorStatusBuilder builder;

        StatusNestedImpl(ClusterOperatorStatus item) {
            this.builder = new ClusterOperatorStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ClusterOperatorStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterOperatorFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ClusterOperatorSpecFluentImpl<ClusterOperatorFluent.SpecNested<N>>
    implements ClusterOperatorFluent.SpecNested<N>,
    Nested<N> {
        private final ClusterOperatorSpecBuilder builder;

        SpecNestedImpl(ClusterOperatorSpec item) {
            this.builder = new ClusterOperatorSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ClusterOperatorSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterOperatorFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterOperatorFluent.MetadataNested<N>>
    implements ClusterOperatorFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterOperatorFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

