/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_12.server.mock;

import io.fabric8.kubernetes.clnt.v4_12.KubernetesClient;
import io.fabric8.kubernetes.clnt.v4_12.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_12.server.mock.EnableKubernetesMockClient;
import io.fabric8.kubernetes.clnt.v4_12.server.mock.KubernetesCrudDispatcher;
import io.fabric8.kubernetes.clnt.v4_12.server.mock.KubernetesMockServer;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class KubernetesMockServerExtension
implements AfterEachCallback,
AfterAllCallback,
BeforeEachCallback,
BeforeAllCallback {
    private KubernetesMockServer mock;
    private NamespacedKubernetesClient client;

    public void afterEach(ExtensionContext context) throws Exception {
        Class testClass;
        Optional optClass = context.getTestClass();
        if (optClass.isPresent() && this.findField(testClass = (Class)optClass.get(), true) == null) {
            this.destroy();
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.destroy();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.setKubernetesClientField(context, false);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.setKubernetesClientField(context, true);
    }

    private void setKubernetesClientField(ExtensionContext context, boolean isStatic) throws IllegalAccessException {
        Optional optClass = context.getTestClass();
        if (optClass.isPresent()) {
            Field[] fields;
            Class testClass = (Class)optClass.get();
            for (Field f : fields = testClass.getDeclaredFields()) {
                if (f.getType() != KubernetesClient.class || Modifier.isStatic(f.getModifiers()) != isStatic) continue;
                this.createKubernetesClient(testClass);
                f.setAccessible(true);
                if (isStatic) {
                    f.set(null, this.client);
                    continue;
                }
                Optional optTestInstance = context.getTestInstance();
                if (!optTestInstance.isPresent()) continue;
                f.set(optTestInstance.get(), this.client);
            }
        }
    }

    private void createKubernetesClient(Class<?> testClass) {
        EnableKubernetesMockClient a = testClass.getAnnotation(EnableKubernetesMockClient.class);
        this.mock = a.crud() ? new KubernetesMockServer(new Context(), new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), (Dispatcher)new KubernetesCrudDispatcher(Collections.emptyList()), a.https()) : new KubernetesMockServer(a.https());
        this.mock.init();
        this.client = this.mock.createClient();
    }

    private void destroy() {
        this.mock.destroy();
        this.client.close();
    }

    private Field findField(Class<?> testClass, boolean isStatic) {
        Field[] fields;
        for (Field f : fields = testClass.getDeclaredFields()) {
            if (f.getType() != KubernetesClient.class || Modifier.isStatic(f.getModifiers()) != isStatic) continue;
            return f;
        }
        return null;
    }
}

