/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_12.internal.readiness;

import io.fabric8.kubernetes.api.model.v4_12.EndpointSubset;
import io.fabric8.kubernetes.api.model.v4_12.Endpoints;
import io.fabric8.kubernetes.api.model.v4_12.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_12.Node;
import io.fabric8.kubernetes.api.model.v4_12.NodeCondition;
import io.fabric8.kubernetes.api.model.v4_12.Pod;
import io.fabric8.kubernetes.api.model.v4_12.PodCondition;
import io.fabric8.kubernetes.api.model.v4_12.ReplicationController;
import io.fabric8.kubernetes.api.model.v4_12.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.v4_12.ReplicationControllerStatus;
import io.fabric8.kubernetes.api.model.v4_12.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.v4_12.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.v4_12.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.v4_12.apps.ReplicaSetStatus;
import io.fabric8.kubernetes.api.model.v4_12.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.v4_12.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.v4_12.apps.StatefulSetStatus;
import io.fabric8.kubernetes.api.model.v4_12.extensions.Deployment;
import io.fabric8.kubernetes.api.model.v4_12.extensions.DeploymentStatus;
import io.fabric8.kubernetes.clnt.v4_12.utils.Utils;

public class Readiness {
    private static final String POD_READY = "Ready";
    private static final String NODE_READY = "Ready";
    private static final String TRUE = "True";

    public static boolean isReadinessApplicable(Class<? extends HasMetadata> itemClass) {
        return io.fabric8.kubernetes.api.model.v4_12.apps.Deployment.class.isAssignableFrom(itemClass) || Deployment.class.isAssignableFrom(itemClass) || ReplicaSet.class.isAssignableFrom(itemClass) || Pod.class.isAssignableFrom(itemClass) || ReplicationController.class.isAssignableFrom(itemClass) || Endpoints.class.isAssignableFrom(itemClass) || Node.class.isAssignableFrom(itemClass) || StatefulSet.class.isAssignableFrom(itemClass);
    }

    public static boolean isReady(HasMetadata item) {
        if (Readiness.isReadiableKubernetesResource(item)) {
            return Readiness.isKubernetesResourceReady(item);
        }
        throw new IllegalArgumentException("Item needs to be one of [Node, Deployment, ReplicaSet, StatefulSet, Pod, ReplicationController], but was: [" + (item != null ? item.getKind() : "Unknown (null)") + "]");
    }

    private static boolean isKubernetesResourceReady(HasMetadata item) {
        if (item instanceof io.fabric8.kubernetes.api.model.v4_12.apps.Deployment) {
            return Readiness.isDeploymentReady((io.fabric8.kubernetes.api.model.v4_12.apps.Deployment)item);
        }
        if (item instanceof Deployment) {
            return Readiness.isExtensionsDeploymentReady((Deployment)item);
        }
        if (item instanceof ReplicaSet) {
            return Readiness.isReplicaSetReady((ReplicaSet)item);
        }
        if (item instanceof Pod) {
            return Readiness.isPodReady((Pod)item);
        }
        if (item instanceof ReplicationController) {
            return Readiness.isReplicationControllerReady((ReplicationController)item);
        }
        if (item instanceof Endpoints) {
            return Readiness.isEndpointsReady((Endpoints)item);
        }
        if (item instanceof Node) {
            return Readiness.isNodeReady((Node)item);
        }
        if (item instanceof StatefulSet) {
            return Readiness.isStatefulSetReady((StatefulSet)item);
        }
        return false;
    }

    public static boolean isStatefulSetReady(StatefulSet ss) {
        Utils.checkNotNull(ss, "StatefulSet can't be null.");
        StatefulSetSpec spec = ss.getSpec();
        StatefulSetStatus status = ss.getStatus();
        if (status == null || status.getReplicas() == null || status.getReadyReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas().intValue() == status.getReadyReplicas().intValue();
    }

    public static boolean isDeploymentReady(io.fabric8.kubernetes.api.model.v4_12.apps.Deployment d) {
        Utils.checkNotNull(d, "Deployment can't be null.");
        DeploymentSpec spec = d.getSpec();
        io.fabric8.kubernetes.api.model.v4_12.apps.DeploymentStatus status = d.getStatus();
        if (status == null || status.getReplicas() == null || status.getAvailableReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas() <= status.getAvailableReplicas();
    }

    public static boolean isExtensionsDeploymentReady(Deployment d) {
        Utils.checkNotNull(d, "Deployment can't be null.");
        io.fabric8.kubernetes.api.model.v4_12.extensions.DeploymentSpec spec = d.getSpec();
        DeploymentStatus status = d.getStatus();
        if (status == null || status.getReplicas() == null || status.getAvailableReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas() <= status.getAvailableReplicas();
    }

    public static boolean isReplicaSetReady(ReplicaSet r) {
        Utils.checkNotNull(r, "ReplicationController can't be null.");
        ReplicaSetSpec spec = r.getSpec();
        ReplicaSetStatus status = r.getStatus();
        if (status == null || status.getReadyReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReadyReplicas().intValue();
    }

    public static boolean isReplicationControllerReady(ReplicationController r) {
        Utils.checkNotNull(r, "ReplicationController can't be null.");
        ReplicationControllerSpec spec = r.getSpec();
        ReplicationControllerStatus status = r.getStatus();
        if (status == null || status.getReadyReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReadyReplicas().intValue();
    }

    public static boolean isEndpointsReady(Endpoints e) {
        Utils.checkNotNull(e, "Endpoints can't be null.");
        String name = e.getMetadata().getName();
        Utils.checkNotNull(name, "Endpoints name can't be null.");
        if (e.getSubsets() == null) {
            return false;
        }
        for (EndpointSubset subset : e.getSubsets()) {
            if (subset.getAddresses().isEmpty() || subset.getPorts().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPodReady(Pod pod) {
        Utils.checkNotNull(pod, "Pod can't be null.");
        PodCondition condition = Readiness.getPodReadyCondition(pod);
        if (condition == null || condition.getStatus() == null) {
            return false;
        }
        return condition.getStatus().equalsIgnoreCase(TRUE);
    }

    private static PodCondition getPodReadyCondition(Pod pod) {
        Utils.checkNotNull(pod, "Pod can't be null.");
        if (pod.getStatus() == null || pod.getStatus().getConditions() == null) {
            return null;
        }
        for (PodCondition condition : pod.getStatus().getConditions()) {
            if (!"Ready".equals(condition.getType())) continue;
            return condition;
        }
        return null;
    }

    public static boolean isNodeReady(Node node) {
        Utils.checkNotNull(node, "Node can't be null.");
        NodeCondition condition = Readiness.getNodeReadyCondition(node);
        if (condition == null || condition.getStatus() == null) {
            return false;
        }
        return condition.getStatus().equalsIgnoreCase(TRUE);
    }

    private static NodeCondition getNodeReadyCondition(Node node) {
        Utils.checkNotNull(node, "Node can't be null.");
        if (node.getStatus() == null || node.getStatus().getConditions() == null) {
            return null;
        }
        for (NodeCondition condition : node.getStatus().getConditions()) {
            if (!"Ready".equals(condition.getType())) continue;
            return condition;
        }
        return null;
    }

    protected static boolean isReadiableKubernetesResource(HasMetadata item) {
        return item instanceof io.fabric8.kubernetes.api.model.v4_12.apps.Deployment || item instanceof Deployment || item instanceof ReplicaSet || item instanceof Pod || item instanceof ReplicationController || item instanceof Endpoints || item instanceof Node || item instanceof StatefulSet;
    }
}

