/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_12.handlers.core.v1;

import io.fabric8.kubernetes.api.model.v4_12.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_12.ListOptions;
import io.fabric8.kubernetes.api.model.v4_12.Pod;
import io.fabric8.kubernetes.api.model.v4_12.PodBuilder;
import io.fabric8.kubernetes.clnt.v4_12.Config;
import io.fabric8.kubernetes.clnt.v4_12.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_12.Watch;
import io.fabric8.kubernetes.clnt.v4_12.Watcher;
import io.fabric8.kubernetes.clnt.v4_12.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_12.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v4_12.dsl.internal.core.v1.PodOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class PodHandler
implements ResourceHandler<Pod, PodBuilder> {
    @Override
    public String getKind() {
        return Pod.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public Pod create(OkHttpClient client, Config config, String namespace, Pod item) {
        return (Pod)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Pod[0]);
    }

    @Override
    public Pod replace(OkHttpClient client, Config config, String namespace, Pod item) {
        return (Pod)((PodResource)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Pod reload(OkHttpClient client, Config config, String namespace, Pod item) {
        return (Pod)((Gettable)((PodResource)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public PodBuilder edit(Pod item) {
        return new PodBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Pod item) {
        return (Boolean)new PodOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Pod item, Watcher<Pod> watcher) {
        return (Watch)((PodResource)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Pod item, String resourceVersion, Watcher<Pod> watcher) {
        return (Watch)((PodResource)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Pod item, ListOptions options, Watcher<Pod> watcher) {
        return (Watch)((PodResource)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Pod waitUntilReady(OkHttpClient client, Config config, String namespace, Pod item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Pod)((PodResource)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Pod waitUntilCondition(OkHttpClient client, Config config, String namespace, Pod item, Predicate<Pod> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Pod)((PodResource)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

