/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_12.dsl.internal.extensions.v1beta1;

import io.fabric8.kubernetes.api.model.v4_12.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.v4_12.PodList;
import io.fabric8.kubernetes.api.model.v4_12.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v4_12.extensions.Deployment;
import io.fabric8.kubernetes.api.model.v4_12.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.v4_12.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.v4_12.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.v4_12.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.v4_12.extensions.DoneableDeployment;
import io.fabric8.kubernetes.clnt.v4_12.Config;
import io.fabric8.kubernetes.clnt.v4_12.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v4_12.dsl.Operation;
import io.fabric8.kubernetes.clnt.v4_12.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_12.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.clnt.v4_12.dsl.internal.extensions.v1beta1.DeploymentOperationsImpl;
import okhttp3.OkHttpClient;

class DeploymentRollingUpdater
extends RollingUpdater<Deployment, DeploymentList, DoneableDeployment> {
    DeploymentRollingUpdater(OkHttpClient client, Config config, String namespace) {
        super(client, config, namespace);
    }

    DeploymentRollingUpdater(OkHttpClient client, Config config, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(client, config, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected Deployment createClone(Deployment obj, String newName, String newDeploymentHash) {
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(0)).editSelector().addToMatchLabels("deployment", newDeploymentHash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected PodList listSelectedPods(Deployment obj) {
        FilterWatchListDeletable podLister = (FilterWatchListDeletable)this.pods().inNamespace(this.namespace);
        if (obj.getSpec().getSelector().getMatchLabels() != null) {
            podLister.withLabels(obj.getSpec().getSelector().getMatchLabels());
        }
        if (obj.getSpec().getSelector().getMatchExpressions() != null) {
            for (LabelSelectorRequirement req : obj.getSpec().getSelector().getMatchExpressions()) {
                switch (req.getOperator()) {
                    case "In": {
                        podLister.withLabelIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "NotIn": {
                        podLister.withLabelNotIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "DoesNotExist": {
                        podLister.withoutLabel(req.getKey());
                        break;
                    }
                    case "Exists": {
                        podLister.withLabel(req.getKey());
                    }
                }
            }
        }
        return (PodList)podLister.list();
    }

    @Override
    protected void updateDeploymentKey(DoneableDeployment obj, String hash) {
        ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)obj.editSpec().editTemplate().editMetadata().addToAnnotations("deployment", hash)).endMetadata()).endTemplate()).endSpec();
    }

    @Override
    protected void removeDeploymentKey(DoneableDeployment obj) {
        ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)obj.editSpec().editSelector().removeFromMatchLabels("deployment")).endSelector()).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec();
    }

    @Override
    protected int getReplicas(Deployment obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected Deployment setReplicas(Deployment obj, int replicas) {
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)new DeploymentBuilder(obj).editSpec().withReplicas(replicas)).endSpec()).build();
    }

    @Override
    protected Operation<Deployment, DeploymentList, DoneableDeployment, RollableScalableResource<Deployment, DoneableDeployment>> resources() {
        return new DeploymentOperationsImpl(this.client, this.config);
    }
}

