/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_12.dsl.base;

import io.fabric8.kubernetes.api.model.v4_12.apiextensions.v1beta1.CustomResourceDefinition;

public class CustomResourceDefinitionContext {
    private String name;
    private String group;
    private String scope;
    private String plural;
    private String version;
    private String kind;

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getScope() {
        return this.scope;
    }

    public String getPlural() {
        return this.plural;
    }

    public String getVersion() {
        return this.version;
    }

    public String getKind() {
        return this.kind;
    }

    public static CustomResourceDefinitionContext fromCrd(CustomResourceDefinition crd) {
        return new Builder().withGroup(crd.getSpec().getGroup()).withVersion(crd.getSpec().getVersion()).withScope(crd.getSpec().getScope()).withName(crd.getMetadata().getName()).withPlural(crd.getSpec().getNames().getPlural()).withKind(crd.getSpec().getNames().getKind()).build();
    }

    public static class Builder {
        private final CustomResourceDefinitionContext customResourceDefinitionContext = new CustomResourceDefinitionContext();

        public Builder withName(String name) {
            this.customResourceDefinitionContext.name = name;
            return this;
        }

        public Builder withGroup(String group) {
            this.customResourceDefinitionContext.group = group;
            return this;
        }

        public Builder withScope(String scope) {
            this.customResourceDefinitionContext.scope = scope;
            return this;
        }

        public Builder withPlural(String plural) {
            this.customResourceDefinitionContext.plural = plural;
            return this;
        }

        public Builder withVersion(String version) {
            this.customResourceDefinitionContext.version = version;
            return this;
        }

        public Builder withKind(String kind) {
            this.customResourceDefinitionContext.kind = kind;
            return this;
        }

        public CustomResourceDefinitionContext build() {
            return this.customResourceDefinitionContext;
        }
    }
}

