/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_12.rbac;

import io.fabric8.kubernetes.api.builder.v4_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_12.Nested;
import io.fabric8.kubernetes.api.builder.v4_12.Predicate;
import io.fabric8.kubernetes.api.model.v4_12.LabelSelector;
import io.fabric8.kubernetes.api.model.v4_12.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v4_12.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v4_12.rbac.AggregationRule;
import io.fabric8.kubernetes.api.model.v4_12.rbac.AggregationRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class AggregationRuleFluentImpl<A extends AggregationRuleFluent<A>>
extends BaseFluent<A>
implements AggregationRuleFluent<A> {
    private List<LabelSelectorBuilder> clusterRoleSelectors = new ArrayList<LabelSelectorBuilder>();

    public AggregationRuleFluentImpl() {
    }

    public AggregationRuleFluentImpl(AggregationRule instance) {
        this.withClusterRoleSelectors(instance.getClusterRoleSelectors());
    }

    @Override
    public A addToClusterRoleSelectors(int index, LabelSelector item) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList<LabelSelectorBuilder>();
        }
        LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
        this._visitables.get("clusterRoleSelectors").add(index >= 0 ? index : this._visitables.get("clusterRoleSelectors").size(), builder);
        this.clusterRoleSelectors.add(index >= 0 ? index : this.clusterRoleSelectors.size(), builder);
        return (A)this;
    }

    @Override
    public A setToClusterRoleSelectors(int index, LabelSelector item) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList<LabelSelectorBuilder>();
        }
        LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
        if (index < 0 || index >= this._visitables.get("clusterRoleSelectors").size()) {
            this._visitables.get("clusterRoleSelectors").add(builder);
        } else {
            this._visitables.get("clusterRoleSelectors").set(index, builder);
        }
        if (index < 0 || index >= this.clusterRoleSelectors.size()) {
            this.clusterRoleSelectors.add(builder);
        } else {
            this.clusterRoleSelectors.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToClusterRoleSelectors(LabelSelector ... items) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList<LabelSelectorBuilder>();
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToClusterRoleSelectors(Collection<LabelSelector> items) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList<LabelSelectorBuilder>();
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusterRoleSelectors(LabelSelector ... items) {
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").remove(builder);
            if (this.clusterRoleSelectors == null) continue;
            this.clusterRoleSelectors.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClusterRoleSelectors(Collection<LabelSelector> items) {
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").remove(builder);
            if (this.clusterRoleSelectors == null) continue;
            this.clusterRoleSelectors.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromClusterRoleSelectors(Predicate<LabelSelectorBuilder> predicate) {
        if (this.clusterRoleSelectors == null) {
            return (A)this;
        }
        Iterator<LabelSelectorBuilder> each = this.clusterRoleSelectors.iterator();
        Object visitables = this._visitables.get("clusterRoleSelectors");
        while (each.hasNext()) {
            LabelSelectorBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LabelSelector> getClusterRoleSelectors() {
        return AggregationRuleFluentImpl.build(this.clusterRoleSelectors);
    }

    @Override
    public List<LabelSelector> buildClusterRoleSelectors() {
        return AggregationRuleFluentImpl.build(this.clusterRoleSelectors);
    }

    @Override
    public LabelSelector buildClusterRoleSelector(int index) {
        return this.clusterRoleSelectors.get(index).build();
    }

    @Override
    public LabelSelector buildFirstClusterRoleSelector() {
        return this.clusterRoleSelectors.get(0).build();
    }

    @Override
    public LabelSelector buildLastClusterRoleSelector() {
        return this.clusterRoleSelectors.get(this.clusterRoleSelectors.size() - 1).build();
    }

    @Override
    public LabelSelector buildMatchingClusterRoleSelector(Predicate<LabelSelectorBuilder> predicate) {
        for (LabelSelectorBuilder item : this.clusterRoleSelectors) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingClusterRoleSelector(Predicate<LabelSelectorBuilder> predicate) {
        for (LabelSelectorBuilder item : this.clusterRoleSelectors) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClusterRoleSelectors(List<LabelSelector> clusterRoleSelectors) {
        if (this.clusterRoleSelectors != null) {
            this._visitables.get("clusterRoleSelectors").removeAll(this.clusterRoleSelectors);
        }
        if (clusterRoleSelectors != null) {
            this.clusterRoleSelectors = new ArrayList<LabelSelectorBuilder>();
            for (LabelSelector item : clusterRoleSelectors) {
                this.addToClusterRoleSelectors(item);
            }
        } else {
            this.clusterRoleSelectors = null;
        }
        return (A)this;
    }

    @Override
    public A withClusterRoleSelectors(LabelSelector ... clusterRoleSelectors) {
        if (this.clusterRoleSelectors != null) {
            this.clusterRoleSelectors.clear();
        }
        if (clusterRoleSelectors != null) {
            for (LabelSelector item : clusterRoleSelectors) {
                this.addToClusterRoleSelectors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterRoleSelectors() {
        return this.clusterRoleSelectors != null && !this.clusterRoleSelectors.isEmpty();
    }

    @Override
    public AggregationRuleFluent.ClusterRoleSelectorsNested<A> addNewClusterRoleSelector() {
        return new ClusterRoleSelectorsNestedImpl();
    }

    @Override
    public AggregationRuleFluent.ClusterRoleSelectorsNested<A> addNewClusterRoleSelectorLike(LabelSelector item) {
        return new ClusterRoleSelectorsNestedImpl(-1, item);
    }

    @Override
    public AggregationRuleFluent.ClusterRoleSelectorsNested<A> setNewClusterRoleSelectorLike(int index, LabelSelector item) {
        return new ClusterRoleSelectorsNestedImpl(index, item);
    }

    @Override
    public AggregationRuleFluent.ClusterRoleSelectorsNested<A> editClusterRoleSelector(int index) {
        if (this.clusterRoleSelectors.size() <= index) {
            throw new RuntimeException("Can't edit clusterRoleSelectors. Index exceeds size.");
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    @Override
    public AggregationRuleFluent.ClusterRoleSelectorsNested<A> editFirstClusterRoleSelector() {
        if (this.clusterRoleSelectors.size() == 0) {
            throw new RuntimeException("Can't edit first clusterRoleSelectors. The list is empty.");
        }
        return this.setNewClusterRoleSelectorLike(0, this.buildClusterRoleSelector(0));
    }

    @Override
    public AggregationRuleFluent.ClusterRoleSelectorsNested<A> editLastClusterRoleSelector() {
        int index = this.clusterRoleSelectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterRoleSelectors. The list is empty.");
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    @Override
    public AggregationRuleFluent.ClusterRoleSelectorsNested<A> editMatchingClusterRoleSelector(Predicate<LabelSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterRoleSelectors.size(); ++i) {
            if (!predicate.apply(this.clusterRoleSelectors.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterRoleSelectors. No match found.");
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationRuleFluentImpl that = (AggregationRuleFluentImpl)o;
        return !(this.clusterRoleSelectors != null ? !this.clusterRoleSelectors.equals(that.clusterRoleSelectors) : that.clusterRoleSelectors != null);
    }

    public int hashCode() {
        return Objects.hash(this.clusterRoleSelectors, super.hashCode());
    }

    public class ClusterRoleSelectorsNestedImpl<N>
    extends LabelSelectorFluentImpl<AggregationRuleFluent.ClusterRoleSelectorsNested<N>>
    implements AggregationRuleFluent.ClusterRoleSelectorsNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;
        private final int index;

        ClusterRoleSelectorsNestedImpl(int index, LabelSelector item) {
            this.index = index;
            this.builder = new LabelSelectorBuilder(this, item);
        }

        ClusterRoleSelectorsNestedImpl() {
            this.index = -1;
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)AggregationRuleFluentImpl.this.setToClusterRoleSelectors(this.index, this.builder.build());
        }

        @Override
        public N endClusterRoleSelector() {
            return this.and();
        }
    }
}

