/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_12.extensions;

import io.fabric8.kubernetes.api.builder.v4_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_12.extensions.IPBlock;
import io.fabric8.kubernetes.api.model.v4_12.extensions.IPBlockFluent;
import io.fabric8.kubernetes.api.model.v4_12.extensions.IPBlockFluentImpl;
import java.util.Objects;

public class IPBlockBuilder
extends IPBlockFluentImpl<IPBlockBuilder>
implements VisitableBuilder<IPBlock, IPBlockBuilder> {
    IPBlockFluent<?> fluent;
    Boolean validationEnabled;

    public IPBlockBuilder() {
        this(true);
    }

    public IPBlockBuilder(Boolean validationEnabled) {
        this(new IPBlock(), validationEnabled);
    }

    public IPBlockBuilder(IPBlockFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IPBlockBuilder(IPBlockFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IPBlock(), validationEnabled);
    }

    public IPBlockBuilder(IPBlockFluent<?> fluent, IPBlock instance) {
        this(fluent, instance, true);
    }

    public IPBlockBuilder(IPBlockFluent<?> fluent, IPBlock instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCidr(instance.getCidr());
        fluent.withExcept(instance.getExcept());
        this.validationEnabled = validationEnabled;
    }

    public IPBlockBuilder(IPBlock instance) {
        this(instance, (Boolean)true);
    }

    public IPBlockBuilder(IPBlock instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCidr(instance.getCidr());
        this.withExcept(instance.getExcept());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public IPBlock build() {
        IPBlock buildable = new IPBlock(this.fluent.getCidr(), this.fluent.getExcept());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IPBlockBuilder that = (IPBlockBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

