/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_12.admission;

import io.fabric8.kubernetes.api.builder.v4_12.BaseFluent;
import io.fabric8.kubernetes.api.model.v4_12.Status;
import io.fabric8.kubernetes.api.model.v4_12.admission.AdmissionResponse;
import io.fabric8.kubernetes.api.model.v4_12.admission.AdmissionResponseFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class AdmissionResponseFluentImpl<A extends AdmissionResponseFluent<A>>
extends BaseFluent<A>
implements AdmissionResponseFluent<A> {
    private Boolean allowed;
    private Map<String, String> auditAnnotations;
    private String patch;
    private String patchType;
    private Status status;
    private String uid;

    public AdmissionResponseFluentImpl() {
    }

    public AdmissionResponseFluentImpl(AdmissionResponse instance) {
        this.withAllowed(instance.getAllowed());
        this.withAuditAnnotations(instance.getAuditAnnotations());
        this.withPatch(instance.getPatch());
        this.withPatchType(instance.getPatchType());
        this.withStatus(instance.getStatus());
        this.withUid(instance.getUid());
    }

    @Override
    public Boolean isAllowed() {
        return this.allowed;
    }

    @Override
    public A withAllowed(Boolean allowed) {
        this.allowed = allowed;
        return (A)this;
    }

    @Override
    public Boolean hasAllowed() {
        return this.allowed != null;
    }

    @Override
    public A withNewAllowed(String arg1) {
        return this.withAllowed(new Boolean(arg1));
    }

    @Override
    public A withNewAllowed(boolean arg1) {
        return this.withAllowed(new Boolean(arg1));
    }

    @Override
    public A addToAuditAnnotations(String key, String value) {
        if (this.auditAnnotations == null && key != null && value != null) {
            this.auditAnnotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.auditAnnotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAuditAnnotations(Map<String, String> map) {
        if (this.auditAnnotations == null && map != null) {
            this.auditAnnotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.auditAnnotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAuditAnnotations(String key) {
        if (this.auditAnnotations == null) {
            return (A)this;
        }
        if (key != null && this.auditAnnotations != null) {
            this.auditAnnotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAuditAnnotations(Map<String, String> map) {
        if (this.auditAnnotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.auditAnnotations == null) continue;
                this.auditAnnotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAuditAnnotations() {
        return this.auditAnnotations;
    }

    @Override
    public A withAuditAnnotations(Map<String, String> auditAnnotations) {
        this.auditAnnotations = auditAnnotations == null ? null : new LinkedHashMap<String, String>(auditAnnotations);
        return (A)this;
    }

    @Override
    public Boolean hasAuditAnnotations() {
        return this.auditAnnotations != null;
    }

    @Override
    public String getPatch() {
        return this.patch;
    }

    @Override
    public A withPatch(String patch) {
        this.patch = patch;
        return (A)this;
    }

    @Override
    public Boolean hasPatch() {
        return this.patch != null;
    }

    @Override
    public A withNewPatch(String arg1) {
        return this.withPatch(new String(arg1));
    }

    @Override
    public A withNewPatch(StringBuilder arg1) {
        return this.withPatch(new String(arg1));
    }

    @Override
    public A withNewPatch(StringBuffer arg1) {
        return this.withPatch(new String(arg1));
    }

    @Override
    public String getPatchType() {
        return this.patchType;
    }

    @Override
    public A withPatchType(String patchType) {
        this.patchType = patchType;
        return (A)this;
    }

    @Override
    public Boolean hasPatchType() {
        return this.patchType != null;
    }

    @Override
    public A withNewPatchType(String arg1) {
        return this.withPatchType(new String(arg1));
    }

    @Override
    public A withNewPatchType(StringBuilder arg1) {
        return this.withPatchType(new String(arg1));
    }

    @Override
    public A withNewPatchType(StringBuffer arg1) {
        return this.withPatchType(new String(arg1));
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public A withStatus(Status status) {
        this.status = status;
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    public A withNewUid(String arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public A withNewUid(StringBuilder arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public A withNewUid(StringBuffer arg1) {
        return this.withUid(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdmissionResponseFluentImpl that = (AdmissionResponseFluentImpl)o;
        if (this.allowed != null ? !this.allowed.equals(that.allowed) : that.allowed != null) {
            return false;
        }
        if (this.auditAnnotations != null ? !this.auditAnnotations.equals(that.auditAnnotations) : that.auditAnnotations != null) {
            return false;
        }
        if (this.patch != null ? !this.patch.equals(that.patch) : that.patch != null) {
            return false;
        }
        if (this.patchType != null ? !this.patchType.equals(that.patchType) : that.patchType != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.uid != null ? !this.uid.equals(that.uid) : that.uid != null);
    }

    public int hashCode() {
        return Objects.hash(this.allowed, this.auditAnnotations, this.patch, this.patchType, this.status, this.uid, super.hashCode());
    }
}

