/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_12;

import io.fabric8.kubernetes.api.builder.v4_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_12.WindowsSecurityContextOptions;
import io.fabric8.kubernetes.api.model.v4_12.WindowsSecurityContextOptionsFluent;
import io.fabric8.kubernetes.api.model.v4_12.WindowsSecurityContextOptionsFluentImpl;
import java.util.Objects;

public class WindowsSecurityContextOptionsBuilder
extends WindowsSecurityContextOptionsFluentImpl<WindowsSecurityContextOptionsBuilder>
implements VisitableBuilder<WindowsSecurityContextOptions, WindowsSecurityContextOptionsBuilder> {
    WindowsSecurityContextOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public WindowsSecurityContextOptionsBuilder() {
        this(true);
    }

    public WindowsSecurityContextOptionsBuilder(Boolean validationEnabled) {
        this(new WindowsSecurityContextOptions(), validationEnabled);
    }

    public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new WindowsSecurityContextOptions(), validationEnabled);
    }

    public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent, WindowsSecurityContextOptions instance) {
        this(fluent, instance, true);
    }

    public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent, WindowsSecurityContextOptions instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withGmsaCredentialSpec(instance.getGmsaCredentialSpec());
        fluent.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName());
        fluent.withRunAsUserName(instance.getRunAsUserName());
        this.validationEnabled = validationEnabled;
    }

    public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptions instance) {
        this(instance, (Boolean)true);
    }

    public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptions instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withGmsaCredentialSpec(instance.getGmsaCredentialSpec());
        this.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName());
        this.withRunAsUserName(instance.getRunAsUserName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public WindowsSecurityContextOptions build() {
        WindowsSecurityContextOptions buildable = new WindowsSecurityContextOptions(this.fluent.getGmsaCredentialSpec(), this.fluent.getGmsaCredentialSpecName(), this.fluent.getRunAsUserName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WindowsSecurityContextOptionsBuilder that = (WindowsSecurityContextOptionsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

