/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_12;

import io.fabric8.kubernetes.api.builder.v4_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_12.ServiceReference;
import io.fabric8.kubernetes.api.model.v4_12.ServiceReferenceFluent;
import io.fabric8.kubernetes.api.model.v4_12.ServiceReferenceFluentImpl;
import java.util.Objects;

public class ServiceReferenceBuilder
extends ServiceReferenceFluentImpl<ServiceReferenceBuilder>
implements VisitableBuilder<ServiceReference, ServiceReferenceBuilder> {
    ServiceReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceReferenceBuilder() {
        this(true);
    }

    public ServiceReferenceBuilder(Boolean validationEnabled) {
        this(new ServiceReference(), validationEnabled);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceReference(), validationEnabled);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent, ServiceReference instance) {
        this(fluent, instance, true);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent, ServiceReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withPort(instance.getPort());
        this.validationEnabled = validationEnabled;
    }

    public ServiceReferenceBuilder(ServiceReference instance) {
        this(instance, (Boolean)true);
    }

    public ServiceReferenceBuilder(ServiceReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withPort(instance.getPort());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ServiceReference build() {
        ServiceReference buildable = new ServiceReference(this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getPort());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceReferenceBuilder that = (ServiceReferenceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

