/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_12;

import io.fabric8.kubernetes.api.builder.v4_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_12.ServicePort;
import io.fabric8.kubernetes.api.model.v4_12.ServicePortFluent;
import io.fabric8.kubernetes.api.model.v4_12.ServicePortFluentImpl;
import java.util.Objects;

public class ServicePortBuilder
extends ServicePortFluentImpl<ServicePortBuilder>
implements VisitableBuilder<ServicePort, ServicePortBuilder> {
    ServicePortFluent<?> fluent;
    Boolean validationEnabled;

    public ServicePortBuilder() {
        this(true);
    }

    public ServicePortBuilder(Boolean validationEnabled) {
        this(new ServicePort(), validationEnabled);
    }

    public ServicePortBuilder(ServicePortFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServicePortBuilder(ServicePortFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServicePort(), validationEnabled);
    }

    public ServicePortBuilder(ServicePortFluent<?> fluent, ServicePort instance) {
        this(fluent, instance, true);
    }

    public ServicePortBuilder(ServicePortFluent<?> fluent, ServicePort instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAppProtocol(instance.getAppProtocol());
        fluent.withName(instance.getName());
        fluent.withNodePort(instance.getNodePort());
        fluent.withPort(instance.getPort());
        fluent.withProtocol(instance.getProtocol());
        fluent.withTargetPort(instance.getTargetPort());
        this.validationEnabled = validationEnabled;
    }

    public ServicePortBuilder(ServicePort instance) {
        this(instance, (Boolean)true);
    }

    public ServicePortBuilder(ServicePort instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAppProtocol(instance.getAppProtocol());
        this.withName(instance.getName());
        this.withNodePort(instance.getNodePort());
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
        this.withTargetPort(instance.getTargetPort());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ServicePort build() {
        ServicePort buildable = new ServicePort(this.fluent.getAppProtocol(), this.fluent.getName(), this.fluent.getNodePort(), this.fluent.getPort(), this.fluent.getProtocol(), this.fluent.getTargetPort());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServicePortBuilder that = (ServicePortBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

