/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_12;

import io.fabric8.kubernetes.api.builder.v4_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_12.ReplicationControllerStatus;
import io.fabric8.kubernetes.api.model.v4_12.ReplicationControllerStatusFluent;
import io.fabric8.kubernetes.api.model.v4_12.ReplicationControllerStatusFluentImpl;
import java.util.Objects;

public class ReplicationControllerStatusBuilder
extends ReplicationControllerStatusFluentImpl<ReplicationControllerStatusBuilder>
implements VisitableBuilder<ReplicationControllerStatus, ReplicationControllerStatusBuilder> {
    ReplicationControllerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ReplicationControllerStatusBuilder() {
        this(true);
    }

    public ReplicationControllerStatusBuilder(Boolean validationEnabled) {
        this(new ReplicationControllerStatus(), validationEnabled);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ReplicationControllerStatus(), validationEnabled);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent, ReplicationControllerStatus instance) {
        this(fluent, instance, true);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent, ReplicationControllerStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAvailableReplicas(instance.getAvailableReplicas());
        fluent.withConditions(instance.getConditions());
        fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReadyReplicas(instance.getReadyReplicas());
        fluent.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatus instance) {
        this(instance, (Boolean)true);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAvailableReplicas(instance.getAvailableReplicas());
        this.withConditions(instance.getConditions());
        this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ReplicationControllerStatus build() {
        ReplicationControllerStatus buildable = new ReplicationControllerStatus(this.fluent.getAvailableReplicas(), this.fluent.getConditions(), this.fluent.getFullyLabeledReplicas(), this.fluent.getObservedGeneration(), this.fluent.getReadyReplicas(), this.fluent.getReplicas());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicationControllerStatusBuilder that = (ReplicationControllerStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

