/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_12;

import io.fabric8.kubernetes.api.builder.v4_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_12.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.v4_12.LoadBalancerIngressFluent;
import io.fabric8.kubernetes.api.model.v4_12.LoadBalancerIngressFluentImpl;
import java.util.Objects;

public class LoadBalancerIngressBuilder
extends LoadBalancerIngressFluentImpl<LoadBalancerIngressBuilder>
implements VisitableBuilder<LoadBalancerIngress, LoadBalancerIngressBuilder> {
    LoadBalancerIngressFluent<?> fluent;
    Boolean validationEnabled;

    public LoadBalancerIngressBuilder() {
        this(true);
    }

    public LoadBalancerIngressBuilder(Boolean validationEnabled) {
        this(new LoadBalancerIngress(), validationEnabled);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new LoadBalancerIngress(), validationEnabled);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent, LoadBalancerIngress instance) {
        this(fluent, instance, true);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent, LoadBalancerIngress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHostname(instance.getHostname());
        fluent.withIp(instance.getIp());
        this.validationEnabled = validationEnabled;
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngress instance) {
        this(instance, (Boolean)true);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHostname(instance.getHostname());
        this.withIp(instance.getIp());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public LoadBalancerIngress build() {
        LoadBalancerIngress buildable = new LoadBalancerIngress(this.fluent.getHostname(), this.fluent.getIp());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoadBalancerIngressBuilder that = (LoadBalancerIngressBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

