/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_12;

import io.fabric8.kubernetes.api.builder.v4_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_12.ContainerPort;
import io.fabric8.kubernetes.api.model.v4_12.ContainerPortFluent;
import io.fabric8.kubernetes.api.model.v4_12.ContainerPortFluentImpl;
import java.util.Objects;

public class ContainerPortBuilder
extends ContainerPortFluentImpl<ContainerPortBuilder>
implements VisitableBuilder<ContainerPort, ContainerPortBuilder> {
    ContainerPortFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerPortBuilder() {
        this(true);
    }

    public ContainerPortBuilder(Boolean validationEnabled) {
        this(new ContainerPort(), validationEnabled);
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerPort(), validationEnabled);
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent, ContainerPort instance) {
        this(fluent, instance, true);
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent, ContainerPort instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withContainerPort(instance.getContainerPort());
        fluent.withHostIP(instance.getHostIP());
        fluent.withHostPort(instance.getHostPort());
        fluent.withName(instance.getName());
        fluent.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    public ContainerPortBuilder(ContainerPort instance) {
        this(instance, (Boolean)true);
    }

    public ContainerPortBuilder(ContainerPort instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withContainerPort(instance.getContainerPort());
        this.withHostIP(instance.getHostIP());
        this.withHostPort(instance.getHostPort());
        this.withName(instance.getName());
        this.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ContainerPort build() {
        ContainerPort buildable = new ContainerPort(this.fluent.getContainerPort(), this.fluent.getHostIP(), this.fluent.getHostPort(), this.fluent.getName(), this.fluent.getProtocol());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerPortBuilder that = (ContainerPortBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

