/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_12;

import io.fabric8.kubernetes.api.builder.v4_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_12.Predicate;
import io.fabric8.kubernetes.api.model.v4_12.ContainerImage;
import io.fabric8.kubernetes.api.model.v4_12.ContainerImageFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ContainerImageFluentImpl<A extends ContainerImageFluent<A>>
extends BaseFluent<A>
implements ContainerImageFluent<A> {
    private List<String> names = new ArrayList<String>();
    private Long sizeBytes;

    public ContainerImageFluentImpl() {
    }

    public ContainerImageFluentImpl(ContainerImage instance) {
        this.withNames(instance.getNames());
        this.withSizeBytes(instance.getSizeBytes());
    }

    @Override
    public A addToNames(int index, String item) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        this.names.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNames(int index, String item) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        this.names.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNames(String ... items) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        for (String item : items) {
            this.names.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNames(Collection<String> items) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        for (String item : items) {
            this.names.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNames(String ... items) {
        for (String item : items) {
            if (this.names == null) continue;
            this.names.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNames(Collection<String> items) {
        for (String item : items) {
            if (this.names == null) continue;
            this.names.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getName(int index) {
        return this.names.get(index);
    }

    @Override
    public String getFirstName() {
        return this.names.get(0);
    }

    @Override
    public String getLastName() {
        return this.names.get(this.names.size() - 1);
    }

    @Override
    public String getMatchingName(Predicate<String> predicate) {
        for (String item : this.names) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingName(Predicate<String> predicate) {
        for (String item : this.names) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNames(List<String> names) {
        if (this.names != null) {
            this._visitables.get("names").removeAll(this.names);
        }
        if (names != null) {
            this.names = new ArrayList<String>();
            for (String item : names) {
                this.addToNames(item);
            }
        } else {
            this.names = null;
        }
        return (A)this;
    }

    @Override
    public A withNames(String ... names) {
        if (this.names != null) {
            this.names.clear();
        }
        if (names != null) {
            for (String item : names) {
                this.addToNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNames() {
        return this.names != null && !this.names.isEmpty();
    }

    @Override
    public A addNewName(String arg1) {
        return this.addToNames(new String(arg1));
    }

    @Override
    public A addNewName(StringBuilder arg1) {
        return this.addToNames(new String(arg1));
    }

    @Override
    public A addNewName(StringBuffer arg1) {
        return this.addToNames(new String(arg1));
    }

    @Override
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    @Override
    public A withSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return (A)this;
    }

    @Override
    public Boolean hasSizeBytes() {
        return this.sizeBytes != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerImageFluentImpl that = (ContainerImageFluentImpl)o;
        if (this.names != null ? !this.names.equals(that.names) : that.names != null) {
            return false;
        }
        return !(this.sizeBytes != null ? !this.sizeBytes.equals(that.sizeBytes) : that.sizeBytes != null);
    }

    public int hashCode() {
        return Objects.hash(this.names, this.sizeBytes, super.hashCode());
    }
}

