/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_12;

import io.fabric8.kubernetes.api.builder.v4_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_12.APIService;
import io.fabric8.kubernetes.api.model.v4_12.APIServiceFluent;
import io.fabric8.kubernetes.api.model.v4_12.APIServiceFluentImpl;
import java.util.Objects;

public class APIServiceBuilder
extends APIServiceFluentImpl<APIServiceBuilder>
implements VisitableBuilder<APIService, APIServiceBuilder> {
    APIServiceFluent<?> fluent;
    Boolean validationEnabled;

    public APIServiceBuilder() {
        this(true);
    }

    public APIServiceBuilder(Boolean validationEnabled) {
        this(new APIService(), validationEnabled);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIService(), validationEnabled);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent, APIService instance) {
        this(fluent, instance, true);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent, APIService instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public APIServiceBuilder(APIService instance) {
        this(instance, (Boolean)true);
    }

    public APIServiceBuilder(APIService instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public APIService build() {
        APIService buildable = new APIService(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIServiceBuilder that = (APIServiceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

