/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.builder.v4_10.Visitor;
import io.fabric8.kubernetes.api.model.v4_10.Doneable;
import io.fabric8.kubernetes.api.model.v4_10.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_10.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v4_10.autoscaling.v1.Scale;
import io.fabric8.kubernetes.clnt.v4_10.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_10.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_10.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v4_10.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v4_10.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.clnt.v4_10.utils.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollableScalableResourceOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, D extends Doneable<T>, R extends Resource<T, D>>
extends HasMetadataOperation<T, L, D, R>
implements RollableScalableResource<T, D> {
    private final Logger Log = LoggerFactory.getLogger(this.getClass());
    final boolean rolling;
    final long rollingTimeout;
    final TimeUnit rollingTimeUnit;

    public RollableScalableResourceOperation(RollingOperationContext context) {
        super(context);
        this.rolling = context.getRolling();
        this.rollingTimeout = context.getRollingTimeout();
        this.rollingTimeUnit = context.getRollingTimeUnit();
    }

    protected abstract T withReplicas(int var1);

    protected abstract RollingUpdater<T, L, D> getRollingUpdater(long var1, TimeUnit var3);

    protected abstract int getCurrentReplicas(T var1);

    protected abstract int getDesiredReplicas(T var1);

    protected abstract long getObservedGeneration(T var1);

    @Override
    public T scale(int count) {
        return (T)this.scale(count, false);
    }

    @Override
    public T scale(int count, boolean wait) {
        T res = this.withReplicas(count);
        if (wait) {
            this.waitUntilScaled(count);
            res = this.getMandatory();
        }
        return res;
    }

    @Override
    public Scale scale() {
        return this.handleScale(null);
    }

    @Override
    public Scale scale(Scale scaleParam) {
        return this.handleScale(scaleParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilScaled(int count) {
        ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        Runnable tPoller = () -> {
            try {
                Object t = this.get();
                if (t == null) {
                    if (count == 0) {
                        queue.put(true);
                    } else {
                        queue.put(new IllegalStateException("Can't wait for " + this.getType().getSimpleName() + ": " + name + " in namespace: " + namespace + " to scale. Resource is no longer available."));
                    }
                    return;
                }
                int currentReplicas = this.getCurrentReplicas(t);
                int desiredReplicas = this.getDesiredReplicas(t);
                replicasRef.set(currentReplicas);
                long generation = t.getMetadata().getGeneration() != null ? t.getMetadata().getGeneration() : -1L;
                long observedGeneration = this.getObservedGeneration(t);
                if (observedGeneration >= generation && Objects.equals(desiredReplicas, currentReplicas)) {
                    queue.put(true);
                }
                this.Log.debug("Only {}/{} replicas scheduled for {}: {} in namespace: {} seconds so waiting...", new Object[]{currentReplicas, desiredReplicas, t.getKind(), t.getMetadata().getName(), namespace});
            }
            catch (Throwable t) {
                this.Log.error("Error while waiting for resource to be scaled.", t);
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(tPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            if (Utils.waitUntilReady(queue, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS)) {
                this.Log.debug("{}/{} pod(s) ready for {}: {} in namespace: {}.", new Object[]{replicasRef.get(), count, this.getType().getSimpleName(), name, namespace});
            } else {
                this.Log.error("{}/{} pod(s) ready for {}: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, this.getType().getSimpleName(), name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
            }
        }
        finally {
            poller.cancel(true);
            executor.shutdown();
        }
    }

    @Override
    public D edit() {
        if (!this.rolling) {
            return (D)super.edit();
        }
        Visitor<HasMetadata> visitor = t -> {
            try {
                this.getRollingUpdater(this.rollingTimeout, this.rollingTimeUnit).rollUpdate((HasMetadata)this.getMandatory(), (HasMetadata)t);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        };
        try {
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Visitor.class).newInstance(this.get(), visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T replace(T t) {
        if (!this.rolling) {
            return super.replace(t);
        }
        return this.getRollingUpdater(this.rollingTimeout, this.rollingTimeUnit).rollUpdate(this.getMandatory(), t);
    }

    @Override
    public T patch(T t) {
        if (!this.rolling) {
            return super.patch(t);
        }
        return this.getRollingUpdater(this.rollingTimeout, this.rollingTimeUnit).rollUpdate(this.getMandatory(), t);
    }
}

