/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.v4_10.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.v4_10.PodList;
import io.fabric8.kubernetes.api.model.v4_10.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v4_10.apps.DoneableReplicaSet;
import io.fabric8.kubernetes.api.model.v4_10.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.v4_10.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.v4_10.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.v4_10.apps.ReplicaSetList;
import io.fabric8.kubernetes.api.model.v4_10.apps.ReplicaSetSpecFluent;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Operation;
import io.fabric8.kubernetes.clnt.v4_10.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_10.dsl.internal.apps.v1.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_10.dsl.internal.apps.v1.RollingUpdater;
import okhttp3.OkHttpClient;

class ReplicaSetRollingUpdater
extends RollingUpdater<ReplicaSet, ReplicaSetList, DoneableReplicaSet> {
    ReplicaSetRollingUpdater(OkHttpClient client, Config config, String namespace) {
        super(client, config, namespace);
    }

    ReplicaSetRollingUpdater(OkHttpClient client, Config config, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(client, config, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected ReplicaSet createClone(ReplicaSet obj, String newName, String newDeploymentHash) {
        return ((ReplicaSetBuilder)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)((ReplicaSetFluent.SpecNested)((ReplicaSetBuilder)((ReplicaSetFluent.MetadataNested)((ReplicaSetFluent.MetadataNested)new ReplicaSetBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(0)).editSelector().addToMatchLabels("deployment", newDeploymentHash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected PodList listSelectedPods(ReplicaSet obj) {
        FilterWatchListDeletable podLister = (FilterWatchListDeletable)this.pods().inNamespace(this.namespace);
        if (obj.getSpec().getSelector().getMatchLabels() != null) {
            podLister.withLabels(obj.getSpec().getSelector().getMatchLabels());
        }
        if (obj.getSpec().getSelector().getMatchExpressions() != null) {
            for (LabelSelectorRequirement req : obj.getSpec().getSelector().getMatchExpressions()) {
                switch (req.getOperator()) {
                    case "In": {
                        podLister.withLabelIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "NotIn": {
                        podLister.withLabelNotIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "DoesNotExist": {
                        podLister.withoutLabel(req.getKey());
                        break;
                    }
                    case "Exists": {
                        podLister.withLabel(req.getKey());
                    }
                }
            }
        }
        return (PodList)podLister.list();
    }

    @Override
    protected void updateDeploymentKey(DoneableReplicaSet obj, String hash) {
        ((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)obj.editSpec().editSelector().addToMatchLabels("deployment", hash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", hash)).endMetadata()).endTemplate()).endSpec();
    }

    @Override
    protected void removeDeploymentKey(DoneableReplicaSet obj) {
        ((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)obj.editSpec().editSelector().removeFromMatchLabels("deployment")).endSelector()).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec();
    }

    @Override
    protected int getReplicas(ReplicaSet obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected ReplicaSet setReplicas(ReplicaSet obj, int replicas) {
        return ((ReplicaSetBuilder)((ReplicaSetFluent.SpecNested)new ReplicaSetBuilder(obj).editSpec().withReplicas(replicas)).endSpec()).build();
    }

    @Override
    protected Operation<ReplicaSet, ReplicaSetList, DoneableReplicaSet, RollableScalableResource<ReplicaSet, DoneableReplicaSet>> resources() {
        return new ReplicaSetOperationsImpl(this.client, this.config);
    }
}

