/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10.dsl.base;

import io.fabric8.kubernetes.api.model.v4_10.HasMetadata;
import io.fabric8.kubernetes.clnt.v4_10.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_10.Watcher;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public class WaitForConditionWatcher<T extends HasMetadata>
implements Watcher<T> {
    private final Predicate<T> condition;
    private final CompletableFuture<T> future;

    public WaitForConditionWatcher(Predicate<T> condition) {
        this.condition = condition;
        this.future = new CompletableFuture();
    }

    public CompletableFuture<T> getFuture() {
        return this.future;
    }

    @Override
    public void eventReceived(Watcher.Action action, T resource) {
        switch (action) {
            case ADDED: 
            case MODIFIED: {
                if (!this.condition.test(resource)) break;
                this.future.complete(resource);
                break;
            }
            case DELETED: {
                if (!this.condition.test(null)) break;
                this.future.complete(null);
                break;
            }
            case ERROR: {
                this.future.completeExceptionally(new WatchException("Action.ERROR received"));
            }
        }
    }

    @Override
    public void onClose(KubernetesClientException cause) {
        this.future.completeExceptionally(new WatchException("Watcher closed", cause));
    }

    public static class WatchException
    extends Exception {
        public WatchException(String message, KubernetesClientException cause) {
            super(message, cause);
        }

        public WatchException(String message) {
            super(message);
        }

        public boolean isShouldRetry() {
            return this.getCause() == null || !this.isHttpGone();
        }

        private boolean isHttpGone() {
            KubernetesClientException cause = (KubernetesClientException)this.getCause();
            return cause.getCode() == 410 || cause.getStatus() != null && cause.getStatus().getCode() == 410;
        }
    }
}

