/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10.dsl.base;

import io.fabric8.kubernetes.api.builder.v4_10.Function;
import io.fabric8.kubernetes.api.model.v4_10.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_10.Doneable;
import io.fabric8.kubernetes.api.model.v4_10.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_10.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v4_10.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_10.dsl.base.BaseOperation;
import io.fabric8.kubernetes.clnt.v4_10.dsl.base.OperationContext;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;

public class HasMetadataOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, D extends Doneable<T>, R extends Resource<T, D>>
extends BaseOperation<T, L, D, R> {
    public static final DeletionPropagation DEFAULT_PROPAGATION_POLICY = DeletionPropagation.BACKGROUND;

    public HasMetadataOperation(OperationContext ctx) {
        super(ctx);
    }

    @Override
    public D edit() {
        Function<HasMetadata, HasMetadata> visitor = resource -> {
            try {
                return this.patch((T)resource);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(this.forOperationType("edit"), (Throwable)e);
            }
        };
        try {
            Object item = this.getMandatory();
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Function.class).newInstance(item, visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("edit"), (Throwable)e);
        }
    }

    @Override
    public T replace(T item) {
        String fixedResourceVersion = this.getResourceVersion();
        Exception caught = null;
        int maxTries = 10;
        for (int i = 0; i < maxTries; ++i) {
            try {
                String resourceVersion;
                if (fixedResourceVersion != null) {
                    resourceVersion = fixedResourceVersion;
                } else {
                    HasMetadata got = (HasMetadata)this.fromServer().get();
                    if (got == null) {
                        return null;
                    }
                    resourceVersion = got.getMetadata() != null ? got.getMetadata().getResourceVersion() : null;
                }
                Function<HasMetadata, HasMetadata> visitor = resource -> {
                    try {
                        resource.getMetadata().setResourceVersion(resourceVersion);
                        return this.handleReplace(resource);
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(this.forOperationType("replace"), (Throwable)e);
                    }
                };
                Doneable doneable = (Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Function.class).newInstance(item, visitor);
                return (T)((HasMetadata)doneable.done());
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409 || fixedResourceVersion != null) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(this.forOperationType("replace"), (Throwable)caught);
    }

    @Override
    public T patch(T item) {
        Exception caught = null;
        int maxTries = 10;
        for (int i = 0; i < maxTries; ++i) {
            try {
                HasMetadata got = (HasMetadata)this.fromServer().get();
                if (got == null) {
                    return null;
                }
                String resourceVersion = got.getMetadata() != null ? got.getMetadata().getResourceVersion() : null;
                Function<HasMetadata, HasMetadata> visitor = resource -> {
                    try {
                        resource.getMetadata().setResourceVersion(resourceVersion);
                        return this.handlePatch(got, resource);
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(this.forOperationType("patch"), (Throwable)e);
                    }
                };
                Doneable doneable = (Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Function.class).newInstance(item, visitor);
                return (T)((HasMetadata)doneable.done());
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(this.forOperationType("patch"), (Throwable)caught);
    }
}

