/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10;

import io.fabric8.kubernetes.api.builder.v4_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_10.Predicate;
import io.fabric8.kubernetes.api.model.v4_10.NamedContext;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.ConfigFluent;
import io.fabric8.kubernetes.clnt.v4_10.OAuthTokenProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okhttp3.TlsVersion;

public class ConfigFluentImpl<A extends ConfigFluent<A>>
extends BaseFluent<A>
implements ConfigFluent<A> {
    private boolean trustCerts;
    private boolean disableHostnameVerification;
    private String masterUrl;
    private String apiVersion;
    private String namespace;
    private String caCertFile;
    private String caCertData;
    private String clientCertFile;
    private String clientCertData;
    private String clientKeyFile;
    private String clientKeyData;
    private String clientKeyAlgo;
    private String clientKeyPassphrase;
    private String trustStoreFile;
    private String trustStorePassphrase;
    private String keyStoreFile;
    private String keyStorePassphrase;
    private List<NamedContext> contexts;
    private NamedContext currentContext;
    private String username;
    private String password;
    private String oauthToken;
    private int watchReconnectInterval;
    private int watchReconnectLimit;
    private int connectionTimeout;
    private int requestTimeout;
    private long rollingTimeout;
    private long scaleTimeout;
    private int loggingInterval;
    private long websocketTimeout;
    private long websocketPingInterval;
    private int maxConcurrentRequests;
    private int maxConcurrentRequestsPerHost;
    private String impersonateUsername;
    private OAuthTokenProvider oauthTokenProvider;
    private String impersonateGroup;
    private List<String> impersonateGroups;
    private Map<String, List<String>> impersonateExtras;
    private boolean http2Disable;
    private String httpProxy;
    private String httpsProxy;
    private String proxyUsername;
    private String proxyPassword;
    private List<String> noProxy;
    private String userAgent;
    private List<TlsVersion> tlsVersions;
    private Map<Integer, String> errorMessages;
    private Map<String, String> customHeaders;

    public ConfigFluentImpl() {
    }

    public ConfigFluentImpl(Config instance) {
        this.withMasterUrl(instance.getMasterUrl());
        this.withApiVersion(instance.getApiVersion());
        this.withNamespace(instance.getNamespace());
        this.withTrustCerts(instance.isTrustCerts());
        this.withDisableHostnameVerification(instance.isDisableHostnameVerification());
        this.withCaCertFile(instance.getCaCertFile());
        this.withCaCertData(instance.getCaCertData());
        this.withClientCertFile(instance.getClientCertFile());
        this.withClientCertData(instance.getClientCertData());
        this.withClientKeyFile(instance.getClientKeyFile());
        this.withClientKeyData(instance.getClientKeyData());
        this.withClientKeyAlgo(instance.getClientKeyAlgo());
        this.withClientKeyPassphrase(instance.getClientKeyPassphrase());
        this.withUsername(instance.getUsername());
        this.withPassword(instance.getPassword());
        this.withOauthToken(instance.getOauthToken());
        this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
        this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
        this.withConnectionTimeout(instance.getConnectionTimeout());
        this.withRequestTimeout(instance.getRequestTimeout());
        this.withRollingTimeout(instance.getRollingTimeout());
        this.withScaleTimeout(instance.getScaleTimeout());
        this.withLoggingInterval(instance.getLoggingInterval());
        this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
        this.withHttp2Disable(instance.isHttp2Disable());
        this.withHttpProxy(instance.getHttpProxy());
        this.withHttpsProxy(instance.getHttpsProxy());
        this.withNoProxy(instance.getNoProxy());
        this.withErrorMessages(instance.getErrorMessages());
        this.withUserAgent(instance.getUserAgent());
        this.withTlsVersions(instance.getTlsVersions());
        this.withWebsocketTimeout(instance.getWebsocketTimeout());
        this.withWebsocketPingInterval(instance.getWebsocketPingInterval());
        this.withProxyUsername(instance.getProxyUsername());
        this.withProxyPassword(instance.getProxyPassword());
        this.withTrustStoreFile(instance.getTrustStoreFile());
        this.withTrustStorePassphrase(instance.getTrustStorePassphrase());
        this.withKeyStoreFile(instance.getKeyStoreFile());
        this.withKeyStorePassphrase(instance.getKeyStorePassphrase());
        this.withImpersonateUsername(instance.getImpersonateUsername());
        this.withImpersonateGroups(instance.getImpersonateGroups());
        this.withImpersonateExtras(instance.getImpersonateExtras());
        this.withOauthTokenProvider(instance.getOauthTokenProvider());
        this.withCustomHeaders(instance.getCustomHeaders());
        this.withContexts(instance.getContexts());
        this.withCurrentContext(instance.getCurrentContext());
        this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
        this.withImpersonateGroup(instance.getImpersonateGroup());
    }

    @Override
    public boolean isTrustCerts() {
        return this.trustCerts;
    }

    @Override
    public A withTrustCerts(boolean trustCerts) {
        this.trustCerts = trustCerts;
        return (A)this;
    }

    @Override
    public Boolean hasTrustCerts() {
        return true;
    }

    @Override
    public boolean isDisableHostnameVerification() {
        return this.disableHostnameVerification;
    }

    @Override
    public A withDisableHostnameVerification(boolean disableHostnameVerification) {
        this.disableHostnameVerification = disableHostnameVerification;
        return (A)this;
    }

    @Override
    public Boolean hasDisableHostnameVerification() {
        return true;
    }

    @Override
    public String getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public A withMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
        return (A)this;
    }

    @Override
    public Boolean hasMasterUrl() {
        return this.masterUrl != null;
    }

    @Override
    public A withNewMasterUrl(String arg1) {
        return this.withMasterUrl(new String(arg1));
    }

    @Override
    public A withNewMasterUrl(StringBuilder arg1) {
        return this.withMasterUrl(new String(arg1));
    }

    @Override
    public A withNewMasterUrl(StringBuffer arg1) {
        return this.withMasterUrl(new String(arg1));
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public A withNewNamespace(String arg1) {
        return this.withNamespace(new String(arg1));
    }

    @Override
    public A withNewNamespace(StringBuilder arg1) {
        return this.withNamespace(new String(arg1));
    }

    @Override
    public A withNewNamespace(StringBuffer arg1) {
        return this.withNamespace(new String(arg1));
    }

    @Override
    public String getCaCertFile() {
        return this.caCertFile;
    }

    @Override
    public A withCaCertFile(String caCertFile) {
        this.caCertFile = caCertFile;
        return (A)this;
    }

    @Override
    public Boolean hasCaCertFile() {
        return this.caCertFile != null;
    }

    @Override
    public A withNewCaCertFile(String arg1) {
        return this.withCaCertFile(new String(arg1));
    }

    @Override
    public A withNewCaCertFile(StringBuilder arg1) {
        return this.withCaCertFile(new String(arg1));
    }

    @Override
    public A withNewCaCertFile(StringBuffer arg1) {
        return this.withCaCertFile(new String(arg1));
    }

    @Override
    public String getCaCertData() {
        return this.caCertData;
    }

    @Override
    public A withCaCertData(String caCertData) {
        this.caCertData = caCertData;
        return (A)this;
    }

    @Override
    public Boolean hasCaCertData() {
        return this.caCertData != null;
    }

    @Override
    public A withNewCaCertData(String arg1) {
        return this.withCaCertData(new String(arg1));
    }

    @Override
    public A withNewCaCertData(StringBuilder arg1) {
        return this.withCaCertData(new String(arg1));
    }

    @Override
    public A withNewCaCertData(StringBuffer arg1) {
        return this.withCaCertData(new String(arg1));
    }

    @Override
    public String getClientCertFile() {
        return this.clientCertFile;
    }

    @Override
    public A withClientCertFile(String clientCertFile) {
        this.clientCertFile = clientCertFile;
        return (A)this;
    }

    @Override
    public Boolean hasClientCertFile() {
        return this.clientCertFile != null;
    }

    @Override
    public A withNewClientCertFile(String arg1) {
        return this.withClientCertFile(new String(arg1));
    }

    @Override
    public A withNewClientCertFile(StringBuilder arg1) {
        return this.withClientCertFile(new String(arg1));
    }

    @Override
    public A withNewClientCertFile(StringBuffer arg1) {
        return this.withClientCertFile(new String(arg1));
    }

    @Override
    public String getClientCertData() {
        return this.clientCertData;
    }

    @Override
    public A withClientCertData(String clientCertData) {
        this.clientCertData = clientCertData;
        return (A)this;
    }

    @Override
    public Boolean hasClientCertData() {
        return this.clientCertData != null;
    }

    @Override
    public A withNewClientCertData(String arg1) {
        return this.withClientCertData(new String(arg1));
    }

    @Override
    public A withNewClientCertData(StringBuilder arg1) {
        return this.withClientCertData(new String(arg1));
    }

    @Override
    public A withNewClientCertData(StringBuffer arg1) {
        return this.withClientCertData(new String(arg1));
    }

    @Override
    public String getClientKeyFile() {
        return this.clientKeyFile;
    }

    @Override
    public A withClientKeyFile(String clientKeyFile) {
        this.clientKeyFile = clientKeyFile;
        return (A)this;
    }

    @Override
    public Boolean hasClientKeyFile() {
        return this.clientKeyFile != null;
    }

    @Override
    public A withNewClientKeyFile(String arg1) {
        return this.withClientKeyFile(new String(arg1));
    }

    @Override
    public A withNewClientKeyFile(StringBuilder arg1) {
        return this.withClientKeyFile(new String(arg1));
    }

    @Override
    public A withNewClientKeyFile(StringBuffer arg1) {
        return this.withClientKeyFile(new String(arg1));
    }

    @Override
    public String getClientKeyData() {
        return this.clientKeyData;
    }

    @Override
    public A withClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
        return (A)this;
    }

    @Override
    public Boolean hasClientKeyData() {
        return this.clientKeyData != null;
    }

    @Override
    public A withNewClientKeyData(String arg1) {
        return this.withClientKeyData(new String(arg1));
    }

    @Override
    public A withNewClientKeyData(StringBuilder arg1) {
        return this.withClientKeyData(new String(arg1));
    }

    @Override
    public A withNewClientKeyData(StringBuffer arg1) {
        return this.withClientKeyData(new String(arg1));
    }

    @Override
    public String getClientKeyAlgo() {
        return this.clientKeyAlgo;
    }

    @Override
    public A withClientKeyAlgo(String clientKeyAlgo) {
        this.clientKeyAlgo = clientKeyAlgo;
        return (A)this;
    }

    @Override
    public Boolean hasClientKeyAlgo() {
        return this.clientKeyAlgo != null;
    }

    @Override
    public A withNewClientKeyAlgo(String arg1) {
        return this.withClientKeyAlgo(new String(arg1));
    }

    @Override
    public A withNewClientKeyAlgo(StringBuilder arg1) {
        return this.withClientKeyAlgo(new String(arg1));
    }

    @Override
    public A withNewClientKeyAlgo(StringBuffer arg1) {
        return this.withClientKeyAlgo(new String(arg1));
    }

    @Override
    public String getClientKeyPassphrase() {
        return this.clientKeyPassphrase;
    }

    @Override
    public A withClientKeyPassphrase(String clientKeyPassphrase) {
        this.clientKeyPassphrase = clientKeyPassphrase;
        return (A)this;
    }

    @Override
    public Boolean hasClientKeyPassphrase() {
        return this.clientKeyPassphrase != null;
    }

    @Override
    public A withNewClientKeyPassphrase(String arg1) {
        return this.withClientKeyPassphrase(new String(arg1));
    }

    @Override
    public A withNewClientKeyPassphrase(StringBuilder arg1) {
        return this.withClientKeyPassphrase(new String(arg1));
    }

    @Override
    public A withNewClientKeyPassphrase(StringBuffer arg1) {
        return this.withClientKeyPassphrase(new String(arg1));
    }

    @Override
    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    @Override
    public A withTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
        return (A)this;
    }

    @Override
    public Boolean hasTrustStoreFile() {
        return this.trustStoreFile != null;
    }

    @Override
    public A withNewTrustStoreFile(String arg1) {
        return this.withTrustStoreFile(new String(arg1));
    }

    @Override
    public A withNewTrustStoreFile(StringBuilder arg1) {
        return this.withTrustStoreFile(new String(arg1));
    }

    @Override
    public A withNewTrustStoreFile(StringBuffer arg1) {
        return this.withTrustStoreFile(new String(arg1));
    }

    @Override
    public String getTrustStorePassphrase() {
        return this.trustStorePassphrase;
    }

    @Override
    public A withTrustStorePassphrase(String trustStorePassphrase) {
        this.trustStorePassphrase = trustStorePassphrase;
        return (A)this;
    }

    @Override
    public Boolean hasTrustStorePassphrase() {
        return this.trustStorePassphrase != null;
    }

    @Override
    public A withNewTrustStorePassphrase(String arg1) {
        return this.withTrustStorePassphrase(new String(arg1));
    }

    @Override
    public A withNewTrustStorePassphrase(StringBuilder arg1) {
        return this.withTrustStorePassphrase(new String(arg1));
    }

    @Override
    public A withNewTrustStorePassphrase(StringBuffer arg1) {
        return this.withTrustStorePassphrase(new String(arg1));
    }

    @Override
    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    @Override
    public A withKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
        return (A)this;
    }

    @Override
    public Boolean hasKeyStoreFile() {
        return this.keyStoreFile != null;
    }

    @Override
    public A withNewKeyStoreFile(String arg1) {
        return this.withKeyStoreFile(new String(arg1));
    }

    @Override
    public A withNewKeyStoreFile(StringBuilder arg1) {
        return this.withKeyStoreFile(new String(arg1));
    }

    @Override
    public A withNewKeyStoreFile(StringBuffer arg1) {
        return this.withKeyStoreFile(new String(arg1));
    }

    @Override
    public String getKeyStorePassphrase() {
        return this.keyStorePassphrase;
    }

    @Override
    public A withKeyStorePassphrase(String keyStorePassphrase) {
        this.keyStorePassphrase = keyStorePassphrase;
        return (A)this;
    }

    @Override
    public Boolean hasKeyStorePassphrase() {
        return this.keyStorePassphrase != null;
    }

    @Override
    public A withNewKeyStorePassphrase(String arg1) {
        return this.withKeyStorePassphrase(new String(arg1));
    }

    @Override
    public A withNewKeyStorePassphrase(StringBuilder arg1) {
        return this.withKeyStorePassphrase(new String(arg1));
    }

    @Override
    public A withNewKeyStorePassphrase(StringBuffer arg1) {
        return this.withKeyStorePassphrase(new String(arg1));
    }

    @Override
    public A addToContexts(int index, NamedContext item) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<NamedContext>();
        }
        this.contexts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToContexts(int index, NamedContext item) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<NamedContext>();
        }
        this.contexts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToContexts(NamedContext ... items) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<NamedContext>();
        }
        for (NamedContext item : items) {
            this.contexts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToContexts(Collection<NamedContext> items) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<NamedContext>();
        }
        for (NamedContext item : items) {
            this.contexts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromContexts(NamedContext ... items) {
        for (NamedContext item : items) {
            if (this.contexts == null) continue;
            this.contexts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContexts(Collection<NamedContext> items) {
        for (NamedContext item : items) {
            if (this.contexts == null) continue;
            this.contexts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<NamedContext> getContexts() {
        return this.contexts;
    }

    @Override
    public NamedContext getContext(int index) {
        return this.contexts.get(index);
    }

    @Override
    public NamedContext getFirstContext() {
        return this.contexts.get(0);
    }

    @Override
    public NamedContext getLastContext() {
        return this.contexts.get(this.contexts.size() - 1);
    }

    @Override
    public NamedContext getMatchingContext(Predicate<NamedContext> predicate) {
        for (NamedContext item : this.contexts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContext(Predicate<NamedContext> predicate) {
        for (NamedContext item : this.contexts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContexts(List<NamedContext> contexts) {
        if (this.contexts != null) {
            this._visitables.get("contexts").removeAll(this.contexts);
        }
        if (contexts != null) {
            this.contexts = new ArrayList<NamedContext>();
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        } else {
            this.contexts = null;
        }
        return (A)this;
    }

    @Override
    public A withContexts(NamedContext ... contexts) {
        if (this.contexts != null) {
            this.contexts.clear();
        }
        if (contexts != null) {
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContexts() {
        return this.contexts != null && !this.contexts.isEmpty();
    }

    @Override
    public NamedContext getCurrentContext() {
        return this.currentContext;
    }

    @Override
    public A withCurrentContext(NamedContext currentContext) {
        this.currentContext = currentContext;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentContext() {
        return this.currentContext != null;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    @Override
    public Boolean hasUsername() {
        return this.username != null;
    }

    @Override
    public A withNewUsername(String arg1) {
        return this.withUsername(new String(arg1));
    }

    @Override
    public A withNewUsername(StringBuilder arg1) {
        return this.withUsername(new String(arg1));
    }

    @Override
    public A withNewUsername(StringBuffer arg1) {
        return this.withUsername(new String(arg1));
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public A withPassword(String password) {
        this.password = password;
        return (A)this;
    }

    @Override
    public Boolean hasPassword() {
        return this.password != null;
    }

    @Override
    public A withNewPassword(String arg1) {
        return this.withPassword(new String(arg1));
    }

    @Override
    public A withNewPassword(StringBuilder arg1) {
        return this.withPassword(new String(arg1));
    }

    @Override
    public A withNewPassword(StringBuffer arg1) {
        return this.withPassword(new String(arg1));
    }

    @Override
    public String getOauthToken() {
        return this.oauthToken;
    }

    @Override
    public A withOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
        return (A)this;
    }

    @Override
    public Boolean hasOauthToken() {
        return this.oauthToken != null;
    }

    @Override
    public A withNewOauthToken(String arg1) {
        return this.withOauthToken(new String(arg1));
    }

    @Override
    public A withNewOauthToken(StringBuilder arg1) {
        return this.withOauthToken(new String(arg1));
    }

    @Override
    public A withNewOauthToken(StringBuffer arg1) {
        return this.withOauthToken(new String(arg1));
    }

    @Override
    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    @Override
    public A withWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
        return (A)this;
    }

    @Override
    public Boolean hasWatchReconnectInterval() {
        return true;
    }

    @Override
    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    @Override
    public A withWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
        return (A)this;
    }

    @Override
    public Boolean hasWatchReconnectLimit() {
        return true;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public A withConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasConnectionTimeout() {
        return true;
    }

    @Override
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public A withRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasRequestTimeout() {
        return true;
    }

    @Override
    public long getRollingTimeout() {
        return this.rollingTimeout;
    }

    @Override
    public A withRollingTimeout(long rollingTimeout) {
        this.rollingTimeout = rollingTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasRollingTimeout() {
        return true;
    }

    @Override
    public long getScaleTimeout() {
        return this.scaleTimeout;
    }

    @Override
    public A withScaleTimeout(long scaleTimeout) {
        this.scaleTimeout = scaleTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasScaleTimeout() {
        return true;
    }

    @Override
    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    @Override
    public A withLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
        return (A)this;
    }

    @Override
    public Boolean hasLoggingInterval() {
        return true;
    }

    @Override
    public long getWebsocketTimeout() {
        return this.websocketTimeout;
    }

    @Override
    public A withWebsocketTimeout(long websocketTimeout) {
        this.websocketTimeout = websocketTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasWebsocketTimeout() {
        return true;
    }

    @Override
    public long getWebsocketPingInterval() {
        return this.websocketPingInterval;
    }

    @Override
    public A withWebsocketPingInterval(long websocketPingInterval) {
        this.websocketPingInterval = websocketPingInterval;
        return (A)this;
    }

    @Override
    public Boolean hasWebsocketPingInterval() {
        return true;
    }

    @Override
    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    @Override
    public A withMaxConcurrentRequests(int maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
        return (A)this;
    }

    @Override
    public Boolean hasMaxConcurrentRequests() {
        return true;
    }

    @Override
    public int getMaxConcurrentRequestsPerHost() {
        return this.maxConcurrentRequestsPerHost;
    }

    @Override
    public A withMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost) {
        this.maxConcurrentRequestsPerHost = maxConcurrentRequestsPerHost;
        return (A)this;
    }

    @Override
    public Boolean hasMaxConcurrentRequestsPerHost() {
        return true;
    }

    @Override
    public String getImpersonateUsername() {
        return this.impersonateUsername;
    }

    @Override
    public A withImpersonateUsername(String impersonateUsername) {
        this.impersonateUsername = impersonateUsername;
        return (A)this;
    }

    @Override
    public Boolean hasImpersonateUsername() {
        return this.impersonateUsername != null;
    }

    @Override
    public A withNewImpersonateUsername(String arg1) {
        return this.withImpersonateUsername(new String(arg1));
    }

    @Override
    public A withNewImpersonateUsername(StringBuilder arg1) {
        return this.withImpersonateUsername(new String(arg1));
    }

    @Override
    public A withNewImpersonateUsername(StringBuffer arg1) {
        return this.withImpersonateUsername(new String(arg1));
    }

    @Override
    public OAuthTokenProvider getOauthTokenProvider() {
        return this.oauthTokenProvider;
    }

    @Override
    public A withOauthTokenProvider(OAuthTokenProvider oauthTokenProvider) {
        this.oauthTokenProvider = oauthTokenProvider;
        return (A)this;
    }

    @Override
    public Boolean hasOauthTokenProvider() {
        return this.oauthTokenProvider != null;
    }

    @Override
    public String getImpersonateGroup() {
        return this.impersonateGroup;
    }

    @Override
    public A withImpersonateGroup(String impersonateGroup) {
        this.impersonateGroup = impersonateGroup;
        return (A)this;
    }

    @Override
    public Boolean hasImpersonateGroup() {
        return this.impersonateGroup != null;
    }

    @Override
    public A withNewImpersonateGroup(String arg1) {
        return this.withImpersonateGroup(new String(arg1));
    }

    @Override
    public A withNewImpersonateGroup(StringBuilder arg1) {
        return this.withImpersonateGroup(new String(arg1));
    }

    @Override
    public A withNewImpersonateGroup(StringBuffer arg1) {
        return this.withImpersonateGroup(new String(arg1));
    }

    @Override
    public A withImpersonateGroups(String ... impersonateGroups) {
        if (this.impersonateGroups != null) {
            this.impersonateGroups.clear();
        }
        if (impersonateGroups != null) {
            for (String item : impersonateGroups) {
                this.addToImpersonateGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getImpersonateGroups() {
        int size = this.impersonateGroups != null ? this.impersonateGroups.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.impersonateGroups) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToImpersonateGroups(int index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToImpersonateGroups(int index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToImpersonateGroups(String ... items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToImpersonateGroups(Collection<String> items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromImpersonateGroups(String ... items) {
        for (String item : items) {
            if (this.impersonateGroups == null) continue;
            this.impersonateGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImpersonateGroups(Collection<String> items) {
        for (String item : items) {
            if (this.impersonateGroups == null) continue;
            this.impersonateGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImpersonateGroups() {
        return this.impersonateGroups != null && !this.impersonateGroups.isEmpty();
    }

    @Override
    public A addNewImpersonateGroup(String arg1) {
        return this.addToImpersonateGroups(new String(arg1));
    }

    @Override
    public A addNewImpersonateGroup(StringBuilder arg1) {
        return this.addToImpersonateGroups(new String(arg1));
    }

    @Override
    public A addNewImpersonateGroup(StringBuffer arg1) {
        return this.addToImpersonateGroups(new String(arg1));
    }

    @Override
    public A addToImpersonateExtras(String key, List<String> value) {
        if (this.impersonateExtras == null && key != null && value != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.impersonateExtras.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null && map != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.impersonateExtras.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromImpersonateExtras(String key) {
        if (this.impersonateExtras == null) {
            return (A)this;
        }
        if (key != null && this.impersonateExtras != null) {
            this.impersonateExtras.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.impersonateExtras == null) continue;
                this.impersonateExtras.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, List<String>> getImpersonateExtras() {
        return this.impersonateExtras;
    }

    @Override
    public A withImpersonateExtras(Map<String, List<String>> impersonateExtras) {
        this.impersonateExtras = impersonateExtras == null ? null : new LinkedHashMap<String, List<String>>(impersonateExtras);
        return (A)this;
    }

    @Override
    public Boolean hasImpersonateExtras() {
        return this.impersonateExtras != null;
    }

    @Override
    public boolean isHttp2Disable() {
        return this.http2Disable;
    }

    @Override
    public A withHttp2Disable(boolean http2Disable) {
        this.http2Disable = http2Disable;
        return (A)this;
    }

    @Override
    public Boolean hasHttp2Disable() {
        return true;
    }

    @Override
    public String getHttpProxy() {
        return this.httpProxy;
    }

    @Override
    public A withHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
        return (A)this;
    }

    @Override
    public Boolean hasHttpProxy() {
        return this.httpProxy != null;
    }

    @Override
    public A withNewHttpProxy(String arg1) {
        return this.withHttpProxy(new String(arg1));
    }

    @Override
    public A withNewHttpProxy(StringBuilder arg1) {
        return this.withHttpProxy(new String(arg1));
    }

    @Override
    public A withNewHttpProxy(StringBuffer arg1) {
        return this.withHttpProxy(new String(arg1));
    }

    @Override
    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    @Override
    public A withHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
        return (A)this;
    }

    @Override
    public Boolean hasHttpsProxy() {
        return this.httpsProxy != null;
    }

    @Override
    public A withNewHttpsProxy(String arg1) {
        return this.withHttpsProxy(new String(arg1));
    }

    @Override
    public A withNewHttpsProxy(StringBuilder arg1) {
        return this.withHttpsProxy(new String(arg1));
    }

    @Override
    public A withNewHttpsProxy(StringBuffer arg1) {
        return this.withHttpsProxy(new String(arg1));
    }

    @Override
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Override
    public A withProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return (A)this;
    }

    @Override
    public Boolean hasProxyUsername() {
        return this.proxyUsername != null;
    }

    @Override
    public A withNewProxyUsername(String arg1) {
        return this.withProxyUsername(new String(arg1));
    }

    @Override
    public A withNewProxyUsername(StringBuilder arg1) {
        return this.withProxyUsername(new String(arg1));
    }

    @Override
    public A withNewProxyUsername(StringBuffer arg1) {
        return this.withProxyUsername(new String(arg1));
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    public A withProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return (A)this;
    }

    @Override
    public Boolean hasProxyPassword() {
        return this.proxyPassword != null;
    }

    @Override
    public A withNewProxyPassword(String arg1) {
        return this.withProxyPassword(new String(arg1));
    }

    @Override
    public A withNewProxyPassword(StringBuilder arg1) {
        return this.withProxyPassword(new String(arg1));
    }

    @Override
    public A withNewProxyPassword(StringBuffer arg1) {
        return this.withProxyPassword(new String(arg1));
    }

    @Override
    public A withNoProxy(String ... noProxy) {
        if (this.noProxy != null) {
            this.noProxy.clear();
        }
        if (noProxy != null) {
            for (String item : noProxy) {
                this.addToNoProxy(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getNoProxy() {
        int size = this.noProxy != null ? this.noProxy.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.noProxy) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToNoProxy(int index, String item) {
        if (this.noProxy == null) {
            this.noProxy = new ArrayList<String>();
        }
        this.noProxy.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNoProxy(int index, String item) {
        if (this.noProxy == null) {
            this.noProxy = new ArrayList<String>();
        }
        this.noProxy.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNoProxy(String ... items) {
        if (this.noProxy == null) {
            this.noProxy = new ArrayList<String>();
        }
        for (String item : items) {
            this.noProxy.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNoProxy(Collection<String> items) {
        if (this.noProxy == null) {
            this.noProxy = new ArrayList<String>();
        }
        for (String item : items) {
            this.noProxy.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNoProxy(String ... items) {
        for (String item : items) {
            if (this.noProxy == null) continue;
            this.noProxy.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNoProxy(Collection<String> items) {
        for (String item : items) {
            if (this.noProxy == null) continue;
            this.noProxy.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNoProxy() {
        return this.noProxy != null && !this.noProxy.isEmpty();
    }

    @Override
    public A addNewNoProxy(String arg1) {
        return this.addToNoProxy(new String(arg1));
    }

    @Override
    public A addNewNoProxy(StringBuilder arg1) {
        return this.addToNoProxy(new String(arg1));
    }

    @Override
    public A addNewNoProxy(StringBuffer arg1) {
        return this.addToNoProxy(new String(arg1));
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public A withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return (A)this;
    }

    @Override
    public Boolean hasUserAgent() {
        return this.userAgent != null;
    }

    @Override
    public A withNewUserAgent(String arg1) {
        return this.withUserAgent(new String(arg1));
    }

    @Override
    public A withNewUserAgent(StringBuilder arg1) {
        return this.withUserAgent(new String(arg1));
    }

    @Override
    public A withNewUserAgent(StringBuffer arg1) {
        return this.withUserAgent(new String(arg1));
    }

    @Override
    public A withTlsVersions(TlsVersion ... tlsVersions) {
        if (this.tlsVersions != null) {
            this.tlsVersions.clear();
        }
        if (tlsVersions != null) {
            for (TlsVersion item : tlsVersions) {
                this.addToTlsVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public TlsVersion[] getTlsVersions() {
        int size = this.tlsVersions != null ? this.tlsVersions.size() : 0;
        TlsVersion[] result = new TlsVersion[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (TlsVersion item : this.tlsVersions) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToTlsVersions(int index, TlsVersion item) {
        if (this.tlsVersions == null) {
            this.tlsVersions = new ArrayList<TlsVersion>();
        }
        this.tlsVersions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTlsVersions(int index, TlsVersion item) {
        if (this.tlsVersions == null) {
            this.tlsVersions = new ArrayList<TlsVersion>();
        }
        this.tlsVersions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTlsVersions(TlsVersion ... items) {
        if (this.tlsVersions == null) {
            this.tlsVersions = new ArrayList<TlsVersion>();
        }
        for (TlsVersion item : items) {
            this.tlsVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTlsVersions(Collection<TlsVersion> items) {
        if (this.tlsVersions == null) {
            this.tlsVersions = new ArrayList<TlsVersion>();
        }
        for (TlsVersion item : items) {
            this.tlsVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTlsVersions(TlsVersion ... items) {
        for (TlsVersion item : items) {
            if (this.tlsVersions == null) continue;
            this.tlsVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTlsVersions(Collection<TlsVersion> items) {
        for (TlsVersion item : items) {
            if (this.tlsVersions == null) continue;
            this.tlsVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsVersions() {
        return this.tlsVersions != null && !this.tlsVersions.isEmpty();
    }

    @Override
    public A addToErrorMessages(Integer key, String value) {
        if (this.errorMessages == null && key != null && value != null) {
            this.errorMessages = new LinkedHashMap<Integer, String>();
        }
        if (key != null && value != null) {
            this.errorMessages.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToErrorMessages(Map<Integer, String> map) {
        if (this.errorMessages == null && map != null) {
            this.errorMessages = new LinkedHashMap<Integer, String>();
        }
        if (map != null) {
            this.errorMessages.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromErrorMessages(Integer key) {
        if (this.errorMessages == null) {
            return (A)this;
        }
        if (key != null && this.errorMessages != null) {
            this.errorMessages.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromErrorMessages(Map<Integer, String> map) {
        if (this.errorMessages == null) {
            return (A)this;
        }
        if (map != null) {
            for (Integer key : map.keySet()) {
                if (this.errorMessages == null) continue;
                this.errorMessages.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<Integer, String> getErrorMessages() {
        return this.errorMessages;
    }

    @Override
    public A withErrorMessages(Map<Integer, String> errorMessages) {
        this.errorMessages = errorMessages == null ? null : new LinkedHashMap<Integer, String>(errorMessages);
        return (A)this;
    }

    @Override
    public Boolean hasErrorMessages() {
        return this.errorMessages != null;
    }

    @Override
    public A addToCustomHeaders(String key, String value) {
        if (this.customHeaders == null && key != null && value != null) {
            this.customHeaders = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.customHeaders.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToCustomHeaders(Map<String, String> map) {
        if (this.customHeaders == null && map != null) {
            this.customHeaders = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.customHeaders.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromCustomHeaders(String key) {
        if (this.customHeaders == null) {
            return (A)this;
        }
        if (key != null && this.customHeaders != null) {
            this.customHeaders.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromCustomHeaders(Map<String, String> map) {
        if (this.customHeaders == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.customHeaders == null) continue;
                this.customHeaders.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    @Override
    public A withCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders == null ? null : new LinkedHashMap<String, String>(customHeaders);
        return (A)this;
    }

    @Override
    public Boolean hasCustomHeaders() {
        return this.customHeaders != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigFluentImpl that = (ConfigFluentImpl)o;
        if (this.trustCerts != that.trustCerts) {
            return false;
        }
        if (this.disableHostnameVerification != that.disableHostnameVerification) {
            return false;
        }
        if (this.masterUrl != null ? !this.masterUrl.equals(that.masterUrl) : that.masterUrl != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.caCertFile != null ? !this.caCertFile.equals(that.caCertFile) : that.caCertFile != null) {
            return false;
        }
        if (this.caCertData != null ? !this.caCertData.equals(that.caCertData) : that.caCertData != null) {
            return false;
        }
        if (this.clientCertFile != null ? !this.clientCertFile.equals(that.clientCertFile) : that.clientCertFile != null) {
            return false;
        }
        if (this.clientCertData != null ? !this.clientCertData.equals(that.clientCertData) : that.clientCertData != null) {
            return false;
        }
        if (this.clientKeyFile != null ? !this.clientKeyFile.equals(that.clientKeyFile) : that.clientKeyFile != null) {
            return false;
        }
        if (this.clientKeyData != null ? !this.clientKeyData.equals(that.clientKeyData) : that.clientKeyData != null) {
            return false;
        }
        if (this.clientKeyAlgo != null ? !this.clientKeyAlgo.equals(that.clientKeyAlgo) : that.clientKeyAlgo != null) {
            return false;
        }
        if (this.clientKeyPassphrase != null ? !this.clientKeyPassphrase.equals(that.clientKeyPassphrase) : that.clientKeyPassphrase != null) {
            return false;
        }
        if (this.trustStoreFile != null ? !this.trustStoreFile.equals(that.trustStoreFile) : that.trustStoreFile != null) {
            return false;
        }
        if (this.trustStorePassphrase != null ? !this.trustStorePassphrase.equals(that.trustStorePassphrase) : that.trustStorePassphrase != null) {
            return false;
        }
        if (this.keyStoreFile != null ? !this.keyStoreFile.equals(that.keyStoreFile) : that.keyStoreFile != null) {
            return false;
        }
        if (this.keyStorePassphrase != null ? !this.keyStorePassphrase.equals(that.keyStorePassphrase) : that.keyStorePassphrase != null) {
            return false;
        }
        if (this.contexts != null ? !this.contexts.equals(that.contexts) : that.contexts != null) {
            return false;
        }
        if (this.currentContext != null ? !this.currentContext.equals(that.currentContext) : that.currentContext != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.oauthToken != null ? !this.oauthToken.equals(that.oauthToken) : that.oauthToken != null) {
            return false;
        }
        if (this.watchReconnectInterval != that.watchReconnectInterval) {
            return false;
        }
        if (this.watchReconnectLimit != that.watchReconnectLimit) {
            return false;
        }
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (this.requestTimeout != that.requestTimeout) {
            return false;
        }
        if (this.rollingTimeout != that.rollingTimeout) {
            return false;
        }
        if (this.scaleTimeout != that.scaleTimeout) {
            return false;
        }
        if (this.loggingInterval != that.loggingInterval) {
            return false;
        }
        if (this.websocketTimeout != that.websocketTimeout) {
            return false;
        }
        if (this.websocketPingInterval != that.websocketPingInterval) {
            return false;
        }
        if (this.maxConcurrentRequests != that.maxConcurrentRequests) {
            return false;
        }
        if (this.maxConcurrentRequestsPerHost != that.maxConcurrentRequestsPerHost) {
            return false;
        }
        if (this.impersonateUsername != null ? !this.impersonateUsername.equals(that.impersonateUsername) : that.impersonateUsername != null) {
            return false;
        }
        if (this.oauthTokenProvider != null ? !this.oauthTokenProvider.equals(that.oauthTokenProvider) : that.oauthTokenProvider != null) {
            return false;
        }
        if (this.impersonateGroup != null ? !this.impersonateGroup.equals(that.impersonateGroup) : that.impersonateGroup != null) {
            return false;
        }
        if (this.impersonateGroups != null ? !this.impersonateGroups.equals(that.impersonateGroups) : that.impersonateGroups != null) {
            return false;
        }
        if (this.impersonateExtras != null ? !this.impersonateExtras.equals(that.impersonateExtras) : that.impersonateExtras != null) {
            return false;
        }
        if (this.http2Disable != that.http2Disable) {
            return false;
        }
        if (this.httpProxy != null ? !this.httpProxy.equals(that.httpProxy) : that.httpProxy != null) {
            return false;
        }
        if (this.httpsProxy != null ? !this.httpsProxy.equals(that.httpsProxy) : that.httpsProxy != null) {
            return false;
        }
        if (this.proxyUsername != null ? !this.proxyUsername.equals(that.proxyUsername) : that.proxyUsername != null) {
            return false;
        }
        if (this.proxyPassword != null ? !this.proxyPassword.equals(that.proxyPassword) : that.proxyPassword != null) {
            return false;
        }
        if (this.noProxy != null ? !this.noProxy.equals(that.noProxy) : that.noProxy != null) {
            return false;
        }
        if (this.userAgent != null ? !this.userAgent.equals(that.userAgent) : that.userAgent != null) {
            return false;
        }
        if (this.tlsVersions != null ? !this.tlsVersions.equals(that.tlsVersions) : that.tlsVersions != null) {
            return false;
        }
        if (this.errorMessages != null ? !this.errorMessages.equals(that.errorMessages) : that.errorMessages != null) {
            return false;
        }
        return !(this.customHeaders != null ? !this.customHeaders.equals(that.customHeaders) : that.customHeaders != null);
    }
}

