/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_10.extensions;

import io.fabric8.kubernetes.api.builder.v4_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_10.Nested;
import io.fabric8.kubernetes.api.builder.v4_10.Predicate;
import io.fabric8.kubernetes.api.model.v4_10.extensions.ReplicaSetCondition;
import io.fabric8.kubernetes.api.model.v4_10.extensions.ReplicaSetConditionBuilder;
import io.fabric8.kubernetes.api.model.v4_10.extensions.ReplicaSetConditionFluentImpl;
import io.fabric8.kubernetes.api.model.v4_10.extensions.ReplicaSetStatus;
import io.fabric8.kubernetes.api.model.v4_10.extensions.ReplicaSetStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ReplicaSetStatusFluentImpl<A extends ReplicaSetStatusFluent<A>>
extends BaseFluent<A>
implements ReplicaSetStatusFluent<A> {
    private Integer availableReplicas;
    private List<ReplicaSetConditionBuilder> conditions = new ArrayList<ReplicaSetConditionBuilder>();
    private Integer fullyLabeledReplicas;
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;

    public ReplicaSetStatusFluentImpl() {
    }

    public ReplicaSetStatusFluentImpl(ReplicaSetStatus instance) {
        this.withAvailableReplicas(instance.getAvailableReplicas());
        this.withConditions(instance.getConditions());
        this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
    }

    @Override
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    @Override
    public A withAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasAvailableReplicas() {
        return this.availableReplicas != null;
    }

    @Override
    public A withNewAvailableReplicas(String arg1) {
        return this.withAvailableReplicas(new Integer(arg1));
    }

    @Override
    public A withNewAvailableReplicas(int arg1) {
        return this.withAvailableReplicas(new Integer(arg1));
    }

    @Override
    public A addToConditions(int index, ReplicaSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ReplicaSetConditionBuilder>();
        }
        ReplicaSetConditionBuilder builder = new ReplicaSetConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, ReplicaSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ReplicaSetConditionBuilder>();
        }
        ReplicaSetConditionBuilder builder = new ReplicaSetConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(ReplicaSetCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ReplicaSetConditionBuilder>();
        }
        for (ReplicaSetCondition item : items) {
            ReplicaSetConditionBuilder builder = new ReplicaSetConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<ReplicaSetCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ReplicaSetConditionBuilder>();
        }
        for (ReplicaSetCondition item : items) {
            ReplicaSetConditionBuilder builder = new ReplicaSetConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(ReplicaSetCondition ... items) {
        for (ReplicaSetCondition item : items) {
            ReplicaSetConditionBuilder builder = new ReplicaSetConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<ReplicaSetCondition> items) {
        for (ReplicaSetCondition item : items) {
            ReplicaSetConditionBuilder builder = new ReplicaSetConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ReplicaSetConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ReplicaSetConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            ReplicaSetConditionBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ReplicaSetCondition> getConditions() {
        return ReplicaSetStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<ReplicaSetCondition> buildConditions() {
        return ReplicaSetStatusFluentImpl.build(this.conditions);
    }

    @Override
    public ReplicaSetCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public ReplicaSetCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public ReplicaSetCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public ReplicaSetCondition buildMatchingCondition(Predicate<ReplicaSetConditionBuilder> predicate) {
        for (ReplicaSetConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ReplicaSetConditionBuilder> predicate) {
        for (ReplicaSetConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<ReplicaSetCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<ReplicaSetConditionBuilder>();
            for (ReplicaSetCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(ReplicaSetCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (ReplicaSetCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new ReplicaSetCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public ReplicaSetStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ReplicaSetStatusFluent.ConditionsNested<A> addNewConditionLike(ReplicaSetCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public ReplicaSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index, ReplicaSetCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public ReplicaSetStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ReplicaSetStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public ReplicaSetStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ReplicaSetStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ReplicaSetConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getFullyLabeledReplicas() {
        return this.fullyLabeledReplicas;
    }

    @Override
    public A withFullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasFullyLabeledReplicas() {
        return this.fullyLabeledReplicas != null;
    }

    @Override
    public A withNewFullyLabeledReplicas(String arg1) {
        return this.withFullyLabeledReplicas(new Integer(arg1));
    }

    @Override
    public A withNewFullyLabeledReplicas(int arg1) {
        return this.withFullyLabeledReplicas(new Integer(arg1));
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    @Override
    public A withReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasReadyReplicas() {
        return this.readyReplicas != null;
    }

    @Override
    public A withNewReadyReplicas(String arg1) {
        return this.withReadyReplicas(new Integer(arg1));
    }

    @Override
    public A withNewReadyReplicas(int arg1) {
        return this.withReadyReplicas(new Integer(arg1));
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public A withNewReplicas(String arg1) {
        return this.withReplicas(new Integer(arg1));
    }

    @Override
    public A withNewReplicas(int arg1) {
        return this.withReplicas(new Integer(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaSetStatusFluentImpl that = (ReplicaSetStatusFluentImpl)o;
        if (this.availableReplicas != null ? !this.availableReplicas.equals(that.availableReplicas) : that.availableReplicas != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.fullyLabeledReplicas != null ? !this.fullyLabeledReplicas.equals(that.fullyLabeledReplicas) : that.fullyLabeledReplicas != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        if (this.readyReplicas != null ? !this.readyReplicas.equals(that.readyReplicas) : that.readyReplicas != null) {
            return false;
        }
        return !(this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null);
    }

    public class ConditionsNestedImpl<N>
    extends ReplicaSetConditionFluentImpl<ReplicaSetStatusFluent.ConditionsNested<N>>
    implements ReplicaSetStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final ReplicaSetConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, ReplicaSetCondition item) {
            this.index = index;
            this.builder = new ReplicaSetConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ReplicaSetConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ReplicaSetStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

